/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl;

import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.Ratio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MediaArgsDimension {
    private MediaArgsDimension() {
    }

    @NotNull
    public static Dimension getRequestedDimension(@NotNull MediaArgs mediaArgs) {
        Dimension dimension;
        if (mediaArgs.getFixedWidth() > 0L || mediaArgs.getFixedHeight() > 0L) {
            return new Dimension(mediaArgs.getFixedWidth(), mediaArgs.getFixedHeight());
        }
        MediaFormat mediaFormat = MediaArgsDimension.getFirstMediaFormat(mediaArgs);
        if (mediaFormat != null && (dimension = mediaFormat.getMinDimension()) != null) {
            return dimension;
        }
        return new Dimension(0L, 0L);
    }

    public static double getRequestedRatio(@NotNull MediaArgs mediaArgs) {
        if (mediaArgs.getFixedWidth() > 0L && mediaArgs.getFixedHeight() > 0L) {
            return Ratio.get(mediaArgs.getFixedWidth(), mediaArgs.getFixedHeight());
        }
        MediaFormat mediaFormat = MediaArgsDimension.getFirstMediaFormat(mediaArgs);
        if (mediaFormat != null && mediaFormat.getRatio() > 0.0) {
            return mediaFormat.getRatio();
        }
        return 0.0;
    }

    @Nullable
    public static Dimension getRequestedRatioAsWidthHeight(@NotNull MediaArgs mediaArgs) {
        if (mediaArgs.getFixedWidth() > 0L && mediaArgs.getFixedHeight() > 0L) {
            return new Dimension(mediaArgs.getFixedWidth(), mediaArgs.getFixedHeight());
        }
        MediaFormat mediaFormat = MediaArgsDimension.getFirstMediaFormat(mediaArgs);
        if (mediaFormat != null && mediaFormat.getRatio() > 0.0) {
            double ratioWidth = mediaFormat.getRatioWidthAsDouble();
            double ratioHeight = mediaFormat.getRatioHeightAsDouble();
            if (!(ratioWidth > 0.0) || !(ratioHeight > 0.0)) {
                ratioWidth = mediaFormat.getRatio();
                ratioHeight = 1.0;
            }
            if (ratioWidth % 1.0 > 0.0 || ratioHeight % 1.0 > 0.0) {
                ratioWidth *= 100000.0;
                ratioHeight *= 100000.0;
            }
            return new Dimension(Math.round(ratioWidth), Math.round(ratioHeight));
        }
        return null;
    }

    @Nullable
    public static MediaFormat getFirstMediaFormat(@NotNull MediaArgs mediaArgs) {
        MediaFormat[] mediaFormats = mediaArgs.getMediaFormats();
        if (mediaFormats != null && mediaFormats.length > 0) {
            return mediaFormats[0];
        }
        return null;
    }
}

