/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NextGenDynamicMediaReference {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("^/(urn:[^/]+)/([^/]+)$");
    private static final String ASSET_ID_PREFIX = "urn:";
    private final String assetId;
    private final String fileName;

    public NextGenDynamicMediaReference(@NotNull String assetId, @NotNull String fileName) {
        if (!StringUtils.startsWith((CharSequence)assetId, (CharSequence)ASSET_ID_PREFIX)) {
            throw new IllegalArgumentException("Asset ID must start with 'urn:'");
        }
        this.assetId = assetId;
        this.fileName = fileName;
    }

    @NotNull
    public String getAssetId() {
        return this.assetId;
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public String toReference() {
        return "/" + this.assetId + "/" + this.fileName;
    }

    @Nullable
    public static NextGenDynamicMediaReference fromReference(@Nullable String reference) {
        if (reference == null) {
            return null;
        }
        Matcher matcher = REFERENCE_PATTERN.matcher(reference);
        if (!matcher.matches()) {
            return null;
        }
        String assetId = matcher.group(1);
        String fileName = matcher.group(2);
        return new NextGenDynamicMediaReference(assetId, fileName);
    }

    public static boolean isReference(@Nullable String reference) {
        return reference != null && REFERENCE_PATTERN.matcher(reference).matches();
    }

    public String toString() {
        return this.toReference();
    }
}

