/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl;

import io.wcm.handler.media.Dimension;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaImageDeliveryParams;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NextGenDynamicMediaUrlBuilder {
    static final String PLACEHOLDER_ASSET_ID = "{asset-id}";
    static final String PLACEHOLDER_SEO_NAME = "{seo-name}";
    static final String PLACEHOLDER_FORMAT = "{format}";
    static final String PARAM_PREFER_WEBP = "preferwebp";
    static final String PARAM_WIDTH = "width";
    static final String PARAM_CROP = "crop";
    static final String PARAM_ROTATE = "rotate";
    static final String PARAM_QUALITY = "quality";
    private static final Set<String> SUPPORTED_FORMATS = Set.of("jpg", "png", "gif", "webp");
    private final NextGenDynamicMediaContext context;

    public NextGenDynamicMediaUrlBuilder(@NotNull NextGenDynamicMediaContext context) {
        this.context = context;
    }

    @Nullable
    public String build(@NotNull NextGenDynamicMediaImageDeliveryParams params) {
        String imageDeliveryPath;
        String repositoryId = this.context.getNextGenDynamicMediaConfig().getRepositoryId();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{repositoryId, imageDeliveryPath = this.context.getNextGenDynamicMediaConfig().getImageDeliveryBasePath()})) {
            return null;
        }
        String seoName = FilenameUtils.getBaseName((String)this.context.getReference().getFileName());
        String format = this.context.getDefaultMediaArgs().getEnforceOutputFileExtension();
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = StringUtils.toRootLowerCase((String)FilenameUtils.getExtension((String)this.context.getReference().getFileName()));
        }
        if (!SUPPORTED_FORMATS.contains(format)) {
            format = "jpg";
        }
        imageDeliveryPath = StringUtils.replace((String)imageDeliveryPath, (String)PLACEHOLDER_ASSET_ID, (String)this.context.getReference().getAssetId());
        imageDeliveryPath = StringUtils.replace((String)imageDeliveryPath, (String)PLACEHOLDER_SEO_NAME, (String)seoName);
        imageDeliveryPath = StringUtils.replace((String)imageDeliveryPath, (String)PLACEHOLDER_FORMAT, (String)format);
        Long width = params.getWidth();
        String widthPlaceholder = params.getWidthPlaceholder();
        Dimension cropSmartRatio = params.getCropSmartRatio();
        Integer rotation = params.getRotation();
        Integer quality = params.getQuality();
        TreeMap<String, Object> urlParamMap = new TreeMap<String, Object>();
        urlParamMap.put(PARAM_PREFER_WEBP, "true");
        if (widthPlaceholder != null) {
            urlParamMap.put(PARAM_WIDTH, widthPlaceholder);
        } else if (width != null) {
            urlParamMap.put(PARAM_WIDTH, width.toString());
        }
        if (cropSmartRatio != null) {
            urlParamMap.put(PARAM_CROP, cropSmartRatio.getWidth() + ":" + cropSmartRatio.getHeight() + ",smart");
        }
        if (rotation != null && rotation != 0) {
            urlParamMap.put(PARAM_ROTATE, rotation.toString());
        }
        if (quality != null) {
            urlParamMap.put(PARAM_QUALITY, quality.toString());
        }
        StringBuilder url = new StringBuilder();
        url.append("https://").append(repositoryId).append(imageDeliveryPath);
        String urlParams = urlParamMap.entrySet().stream().map(entry -> NextGenDynamicMediaUrlBuilder.toUrlParam((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.joining("&"));
        if (StringUtils.isNotEmpty((CharSequence)urlParams)) {
            url.append("?").append(urlParams);
        }
        return url.toString();
    }

    @NotNull
    private static String toUrlParam(@NotNull String key, @NotNull String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append("=");
        if (StringUtils.equals((CharSequence)key, (CharSequence)PARAM_CROP)) {
            sb.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        } else {
            sb.append(value);
        }
        return sb.toString();
    }
}

