/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import io.wcm.handler.media.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class CropDimension
extends Dimension {
    private final long left;
    private final long top;
    private final boolean autoCrop;

    public CropDimension(long left, long top, long width, long height) {
        this(left, top, width, height, false);
    }

    public CropDimension(long left, long top, long width, long height, boolean autoCrop) {
        super(width, height);
        this.left = left;
        this.top = top;
        this.autoCrop = autoCrop;
    }

    public long getLeft() {
        return this.left;
    }

    public long getTop() {
        return this.top;
    }

    public long getRight() {
        return this.getLeft() + this.getWidth();
    }

    public long getBottom() {
        return this.getTop() + this.getHeight();
    }

    public boolean isAutoCrop() {
        return this.autoCrop;
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("left", this.getLeft()).append("top", this.getTop()).append("width", this.getWidth()).append("height", this.getHeight()).build();
    }

    @NotNull
    public String getCropString() {
        return this.getLeft() + "," + this.getTop() + "," + this.getRight() + "," + this.getBottom();
    }

    @NotNull
    public String getCropStringWidthHeight() {
        return this.getLeft() + "," + this.getTop() + "," + this.getWidth() + "," + this.getHeight();
    }

    @NotNull
    public Rectangle2D getRectangle() {
        return new Rectangle((int)this.getLeft(), (int)this.getTop(), (int)this.getWidth(), (int)this.getHeight());
    }

    @NotNull
    public static CropDimension fromCropString(@NotNull String cropString) {
        String[] parts;
        if (StringUtils.isEmpty((CharSequence)cropString)) {
            throw new IllegalArgumentException("Invalid crop string: '" + cropString + "'.");
        }
        String crop = cropString;
        if (StringUtils.contains((CharSequence)crop, (CharSequence)"/")) {
            crop = StringUtils.substringBefore((String)crop, (String)"/");
        }
        if ((parts = StringUtils.split((String)crop, (String)",")).length != 4) {
            throw new IllegalArgumentException("Invalid crop string: '" + cropString + "'.");
        }
        long x1 = NumberUtils.toLong((String)parts[0]);
        long y1 = NumberUtils.toLong((String)parts[1]);
        long x2 = NumberUtils.toLong((String)parts[2]);
        long y2 = NumberUtils.toLong((String)parts[3]);
        long width = x2 - x1;
        long height = y2 - y1;
        if (x1 < 0L || y1 < 0L || width <= 0L || height <= 0L) {
            throw new IllegalArgumentException("Invalid crop string: '" + cropString + "'.");
        }
        return new CropDimension(x1, y1, width, height);
    }
}

