/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Span;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.MediaInvalidReason;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.imagemap.ImageMapArea;
import io.wcm.handler.media.spi.MediaSource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@ProviderType
public final class Media {
    @NotNull
    private final MediaSource mediaSource;
    @NotNull
    private MediaRequest mediaRequest;
    private HtmlElement element;
    private Function<Media, HtmlElement> elementBuilder;
    private String url;
    private Asset asset;
    private Collection<Rendition> renditions;
    private CropDimension cropDimension;
    private Integer rotation;
    private List<ImageMapArea> map;
    private MediaInvalidReason mediaInvalidReason;
    private String mediaInvalidReasonCustomMessage;
    private String markup;

    public Media(@NotNull MediaSource mediaSource, @NotNull MediaRequest mediaRequest) {
        this.mediaSource = mediaSource;
        this.mediaRequest = mediaRequest;
    }

    @JsonIgnore
    @NotNull
    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    @JsonIgnore
    @NotNull
    public MediaRequest getMediaRequest() {
        return this.mediaRequest;
    }

    public void setMediaRequest(@NotNull MediaRequest mediaRequest) {
        this.mediaRequest = mediaRequest;
    }

    @JsonIgnore
    @Nullable
    public HtmlElement getElement() {
        if (this.element == null && this.elementBuilder != null) {
            this.element = this.elementBuilder.apply(this);
            this.elementBuilder = null;
        }
        return this.element;
    }

    @JsonIgnore
    @Nullable
    public String getMarkup() {
        HtmlElement el = this.getElement();
        if (this.markup == null && el != null) {
            if (el instanceof Span) {
                StringBuilder result = new StringBuilder();
                for (Element child : el.getChildren()) {
                    result.append(child.toString());
                }
                this.markup = result.toString();
            } else {
                this.markup = el.toString();
            }
        }
        return this.markup;
    }

    public void setElementBuilder(@NotNull Function<Media, HtmlElement> value) {
        this.elementBuilder = value;
        this.markup = null;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String value) {
        this.url = value;
    }

    @Nullable
    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(@Nullable Asset asset) {
        this.asset = asset;
    }

    @JsonIgnore
    @Nullable
    public Rendition getRendition() {
        if (this.renditions == null || this.renditions.isEmpty()) {
            return null;
        }
        return this.renditions.iterator().next();
    }

    @NotNull
    public Collection<Rendition> getRenditions() {
        if (this.renditions == null) {
            return Collections.emptyList();
        }
        return this.renditions;
    }

    public void setRenditions(@Nullable Collection<Rendition> renditions) {
        this.renditions = renditions;
    }

    @JsonIgnore
    @Nullable
    public CropDimension getCropDimension() {
        return this.cropDimension;
    }

    public void setCropDimension(@Nullable CropDimension cropDimension) {
        this.cropDimension = cropDimension;
    }

    @JsonIgnore
    @Nullable
    public Integer getRotation() {
        return this.rotation;
    }

    public void setRotation(@Nullable Integer rotation) {
        this.rotation = rotation;
    }

    @JsonIgnore
    @Nullable
    public List<ImageMapArea> getMap() {
        return this.map;
    }

    public void setMap(@Nullable List<ImageMapArea> map) {
        this.map = map;
    }

    public boolean isValid() {
        return this.mediaInvalidReason == null;
    }

    @JsonIgnore
    @Nullable
    public MediaInvalidReason getMediaInvalidReason() {
        return this.mediaInvalidReason;
    }

    public void setMediaInvalidReason(@Nullable MediaInvalidReason mediaInvalidReason) {
        this.mediaInvalidReason = mediaInvalidReason;
    }

    @Nullable
    public String getMediaInvalidReasonCustomMessage() {
        return this.mediaInvalidReasonCustomMessage;
    }

    public void setMediaInvalidReasonCustomMessage(@Nullable String mediaInvalidReasonCustomMessage) {
        this.mediaInvalidReasonCustomMessage = mediaInvalidReasonCustomMessage;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        sb.append("valid", this.isValid());
        if (this.isValid()) {
            sb.append("url", (Object)this.getUrl());
        } else {
            sb.append("mediaInvalidReason", (Object)this.mediaInvalidReason);
        }
        sb.append("mediaSource", (Object)this.mediaSource.getId());
        if (this.asset != null) {
            sb.append("asset", (Object)this.asset.getPath());
        }
        if (this.renditions != null) {
            sb.append("renditions", this.renditions);
        }
        if (this.cropDimension != null) {
            sb.append("cropDimension", (Object)this.cropDimension);
        }
        if (this.rotation != null) {
            sb.append("rotation", (Object)this.rotation);
        }
        if (this.map != null) {
            sb.append("map", this.map);
        }
        sb.append("mediaRequest", (Object)this.mediaRequest);
        return sb.build();
    }
}

