/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.markup.DragDropSupport;
import io.wcm.handler.media.markup.IPERatioCustomize;
import io.wcm.handler.mediasource.dam.AemRenditionType;
import io.wcm.handler.url.UrlMode;
import io.wcm.wcm.commons.util.AemObjectReflectionToStringBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MediaArgs
implements Cloneable {
    private MediaFormatOption[] mediaFormatOptions;
    private boolean autoCrop;
    private String[] fileExtensions;
    private String enforceOutputFileExtension;
    private UrlMode urlMode;
    private long fixedWidth;
    private long fixedHeight;
    private boolean download;
    private boolean contentDispositionAttachment;
    private String altText;
    private boolean forceAltValueFromAsset;
    private boolean decorative;
    private boolean dummyImage = true;
    private String dummyImageUrl;
    private Set<AemRenditionType> includeAssetAemRenditions;
    private Boolean includeAssetThumbnails;
    private Boolean includeAssetWebRenditions;
    private ImageSizes imageSizes;
    private PictureSource[] pictureSourceSets;
    private Double imageQualityPercentage;
    private DragDropSupport dragDropSupport = DragDropSupport.AUTO;
    private IPERatioCustomize ipeRatioCustomize = IPERatioCustomize.AUTO;
    private boolean dynamicMediaDisabled;
    private boolean webOptimizedImageDeliveryDisabled;
    private ValueMap properties;
    private static final Set<String> ALLOWED_FORCED_FILE_EXTENSIONS = Set.of("jpg", "png");

    public MediaArgs() {
    }

    public MediaArgs(MediaFormat ... mediaFormats) {
        this.mediaFormats(mediaFormats);
    }

    public MediaArgs(String ... mediaFormatNames) {
        this.mediaFormatNames(mediaFormatNames);
    }

    public MediaFormat @Nullable [] getMediaFormats() {
        MediaFormat[] result;
        if (this.mediaFormatOptions != null && (result = (MediaFormat[])Arrays.stream(this.mediaFormatOptions).filter(option -> option.getMediaFormatName() == null).map(MediaFormatOption::getMediaFormat).toArray(MediaFormat[]::new)).length > 0) {
            return result;
        }
        return null;
    }

    @NotNull
    public MediaArgs mediaFormats(MediaFormat ... values) {
        this.mediaFormatOptions = values == null || values.length == 0 ? null : (MediaFormatOption[])Arrays.stream(values).map(mediaFormat -> new MediaFormatOption((MediaFormat)mediaFormat, false)).toArray(MediaFormatOption[]::new);
        return this;
    }

    @NotNull
    public MediaArgs mandatoryMediaFormats(MediaFormat ... values) {
        this.mediaFormatOptions = values == null || values.length == 0 ? null : (MediaFormatOption[])Arrays.stream(values).map(mediaFormat -> new MediaFormatOption((MediaFormat)mediaFormat, true)).toArray(MediaFormatOption[]::new);
        return this;
    }

    @NotNull
    public MediaArgs mediaFormat(MediaFormat value) {
        this.mediaFormatOptions = value == null ? null : new MediaFormatOption[]{new MediaFormatOption(value, false)};
        return this;
    }

    @NotNull
    public MediaArgs mediaFormatsMandatory(boolean value) {
        if (this.mediaFormatOptions != null) {
            this.mediaFormatOptions = (MediaFormatOption[])Arrays.stream(this.mediaFormatOptions).map(option -> option.withMandatory(value)).toArray(MediaFormatOption[]::new);
        }
        return this;
    }

    public String @Nullable [] getMediaFormatNames() {
        String[] result;
        if (this.mediaFormatOptions != null && (result = (String[])Arrays.stream(this.mediaFormatOptions).filter(option -> option.getMediaFormatName() != null).map(MediaFormatOption::getMediaFormatName).toArray(String[]::new)).length > 0) {
            return result;
        }
        return null;
    }

    @NotNull
    public MediaArgs mediaFormatNames(String ... names) {
        this.mediaFormatOptions = names == null || names.length == 0 ? null : (MediaFormatOption[])Arrays.stream(names).map(name -> new MediaFormatOption((String)name, false)).toArray(MediaFormatOption[]::new);
        return this;
    }

    @NotNull
    public MediaArgs mandatoryMediaFormatNames(String ... names) {
        this.mediaFormatOptions = names == null || names.length == 0 ? null : (MediaFormatOption[])Arrays.stream(names).map(name -> new MediaFormatOption((String)name, true)).toArray(MediaFormatOption[]::new);
        return this;
    }

    @NotNull
    public MediaArgs mediaFormatName(String name) {
        this.mediaFormatOptions = name == null ? null : new MediaFormatOption[]{new MediaFormatOption(name, false)};
        return this;
    }

    public MediaFormatOption @Nullable [] getMediaFormatOptions() {
        return this.mediaFormatOptions;
    }

    @NotNull
    public MediaArgs mediaFormatOptions(MediaFormatOption ... values) {
        this.mediaFormatOptions = values == null || values.length == 0 ? null : values;
        return this;
    }

    public boolean isAutoCrop() {
        return this.autoCrop;
    }

    @NotNull
    public MediaArgs autoCrop(boolean value) {
        this.autoCrop = value;
        return this;
    }

    public String @Nullable [] getFileExtensions() {
        return this.fileExtensions;
    }

    @NotNull
    public MediaArgs fileExtensions(String ... values) {
        this.fileExtensions = values == null || values.length == 0 ? null : values;
        return this;
    }

    @NotNull
    public MediaArgs fileExtension(@Nullable String value) {
        this.fileExtensions = value == null ? null : new String[]{value};
        return this;
    }

    @Nullable
    public String getEnforceOutputFileExtension() {
        return this.enforceOutputFileExtension;
    }

    @NotNull
    public MediaArgs enforceOutputFileExtension(@Nullable String value) {
        if (!ALLOWED_FORCED_FILE_EXTENSIONS.contains(value)) {
            throw new IllegalArgumentException("Allowed enforced output file extensions: " + StringUtils.join(ALLOWED_FORCED_FILE_EXTENSIONS, (String)","));
        }
        this.enforceOutputFileExtension = value;
        return this;
    }

    @Nullable
    public UrlMode getUrlMode() {
        return this.urlMode;
    }

    @NotNull
    public MediaArgs urlMode(@Nullable UrlMode value) {
        this.urlMode = value;
        return this;
    }

    public long getFixedWidth() {
        return this.fixedWidth;
    }

    @NotNull
    public MediaArgs fixedWidth(long value) {
        this.fixedWidth = value;
        return this;
    }

    public long getFixedHeight() {
        return this.fixedHeight;
    }

    @NotNull
    public MediaArgs fixedHeight(long value) {
        this.fixedHeight = value;
        return this;
    }

    @NotNull
    public MediaArgs fixedDimension(long widthValue, long heightValue) {
        this.fixedWidth = widthValue;
        this.fixedHeight = heightValue;
        return this;
    }

    public boolean isDownload() {
        return this.download;
    }

    @NotNull
    public MediaArgs download(boolean value) {
        this.download = value;
        return this;
    }

    public boolean isContentDispositionAttachment() {
        return this.contentDispositionAttachment;
    }

    @NotNull
    public MediaArgs contentDispositionAttachment(boolean value) {
        this.contentDispositionAttachment = value;
        return this;
    }

    @Nullable
    public String getAltText() {
        return this.altText;
    }

    @NotNull
    public MediaArgs altText(@Nullable String value) {
        this.altText = value;
        return this;
    }

    public boolean isForceAltValueFromAsset() {
        return this.forceAltValueFromAsset;
    }

    @NotNull
    public MediaArgs forceAltValueFromAsset(boolean value) {
        this.forceAltValueFromAsset = value;
        return this;
    }

    public boolean isDecorative() {
        return this.decorative;
    }

    @NotNull
    public MediaArgs decorative(boolean value) {
        this.decorative = value;
        return this;
    }

    public boolean isDummyImage() {
        return this.dummyImage;
    }

    @NotNull
    public MediaArgs dummyImage(boolean value) {
        this.dummyImage = value;
        return this;
    }

    @Nullable
    public String getDummyImageUrl() {
        return this.dummyImageUrl;
    }

    @NotNull
    public MediaArgs dummyImageUrl(@Nullable String value) {
        this.dummyImageUrl = value;
        return this;
    }

    @Nullable
    public Set<AemRenditionType> getIncludeAssetAemRenditions() {
        return this.includeAssetAemRenditions;
    }

    @NotNull
    public MediaArgs includeAssetAemRenditions(@Nullable Set<AemRenditionType> value) {
        this.includeAssetAemRenditions = value;
        return this;
    }

    @Deprecated(since="2.0.0")
    @Nullable
    public Boolean isIncludeAssetThumbnails() {
        return this.includeAssetThumbnails;
    }

    @Deprecated(since="2.0.0")
    @NotNull
    public MediaArgs includeAssetThumbnails(boolean value) {
        this.includeAssetThumbnails = value;
        return this;
    }

    @Deprecated(since="2.0.0")
    @Nullable
    public Boolean isIncludeAssetWebRenditions() {
        return this.includeAssetWebRenditions;
    }

    @Deprecated(since="2.0.0")
    @NotNull
    public MediaArgs includeAssetWebRenditions(boolean value) {
        this.includeAssetWebRenditions = value;
        return this;
    }

    @Nullable
    public ImageSizes getImageSizes() {
        return this.imageSizes;
    }

    @NotNull
    public MediaArgs imageSizes(@Nullable ImageSizes value) {
        this.imageSizes = value;
        return this;
    }

    public PictureSource @Nullable [] getPictureSources() {
        return this.pictureSourceSets;
    }

    @NotNull
    public MediaArgs pictureSources(PictureSource ... value) {
        this.pictureSourceSets = value;
        return this;
    }

    public boolean isDynamicMediaDisabled() {
        return this.dynamicMediaDisabled;
    }

    @NotNull
    public MediaArgs dynamicMediaDisabled(boolean value) {
        this.dynamicMediaDisabled = value;
        return this;
    }

    public boolean isWebOptimizedImageDeliveryDisabled() {
        return this.webOptimizedImageDeliveryDisabled;
    }

    @NotNull
    public MediaArgs webOptimizedImageDeliveryDisabled(boolean value) {
        this.webOptimizedImageDeliveryDisabled = value;
        return this;
    }

    @Nullable
    public Double getImageQualityPercentage() {
        return this.imageQualityPercentage;
    }

    @NotNull
    public MediaArgs imageQualityPercentage(@Nullable Double value) {
        this.imageQualityPercentage = value;
        return this;
    }

    @NotNull
    public DragDropSupport getDragDropSupport() {
        return this.dragDropSupport;
    }

    @NotNull
    public MediaArgs dragDropSupport(@NotNull DragDropSupport value) {
        this.dragDropSupport = value;
        return this;
    }

    public IPERatioCustomize getIPERatioCustomize() {
        return this.ipeRatioCustomize;
    }

    @NotNull
    public MediaArgs ipeRatioCustomize(@Nullable IPERatioCustomize value) {
        this.ipeRatioCustomize = value;
        return this;
    }

    @NotNull
    public MediaArgs properties(@NotNull Map<String, Object> map) {
        this.getProperties().putAll(map);
        return this;
    }

    @NotNull
    public MediaArgs property(@NotNull String key, @Nullable Object value) {
        this.getProperties().put((Object)key, value);
        return this;
    }

    @NotNull
    public ValueMap getProperties() {
        if (this.properties == null) {
            this.properties = new ValueMapDecorator(new HashMap());
        }
        return this.properties;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
        if (this.mediaFormatOptions != null && this.mediaFormatOptions.length > 0) {
            sb.append("mediaFormats", (Object)("[" + StringUtils.join((Object[])this.mediaFormatOptions, (String)", ") + "]"));
        }
        if (this.autoCrop) {
            sb.append("autoCrop", this.autoCrop);
        }
        if (this.fileExtensions != null && this.fileExtensions.length > 0) {
            sb.append("fileExtensions", (Object)StringUtils.join((Object[])this.fileExtensions, (String)","));
        }
        if (this.enforceOutputFileExtension != null) {
            sb.append("enforceOutputFileExtension", (Object)this.enforceOutputFileExtension);
        }
        if (this.urlMode != null) {
            sb.append("urlMode", (Object)this.urlMode);
        }
        if (this.fixedWidth > 0L) {
            sb.append("fixedWidth", this.fixedWidth);
        }
        if (this.fixedHeight > 0L) {
            sb.append("fixedHeight", this.fixedHeight);
        }
        if (this.download) {
            sb.append("download", this.download);
        }
        if (this.contentDispositionAttachment) {
            sb.append("contentDispositionAttachment", this.contentDispositionAttachment);
        }
        if (this.altText != null) {
            sb.append("altText", (Object)this.altText);
        }
        if (this.forceAltValueFromAsset) {
            sb.append("forceAltValueFromAsset", this.forceAltValueFromAsset);
        }
        if (this.decorative) {
            sb.append("decorative", this.decorative);
        }
        if (!this.dummyImage) {
            sb.append("dummyImage ", this.dummyImage);
        }
        if (this.dummyImageUrl != null) {
            sb.append("dummyImageUrl", (Object)this.dummyImageUrl);
        }
        if (this.includeAssetAemRenditions != null) {
            sb.append("includeAssetAemRenditions", this.includeAssetAemRenditions);
        }
        if (this.includeAssetThumbnails != null) {
            sb.append("includeAssetThumbnails", (Object)this.includeAssetThumbnails);
        }
        if (this.includeAssetWebRenditions != null) {
            sb.append("includeAssetWebRenditions", (Object)this.includeAssetWebRenditions);
        }
        if (this.imageSizes != null) {
            sb.append("imageSizes", (Object)this.imageSizes);
        }
        if (this.pictureSourceSets != null && this.pictureSourceSets.length > 0) {
            sb.append("pictureSourceSets", (Object)("[" + StringUtils.join((Object[])this.pictureSourceSets, (String)",") + "]"));
        }
        if (this.imageQualityPercentage != null) {
            sb.append("imageQualityPercentage ", (Object)this.imageQualityPercentage);
        }
        if (this.dragDropSupport != DragDropSupport.AUTO) {
            sb.append("dragDropSupport ", (Object)this.dragDropSupport);
        }
        if (this.ipeRatioCustomize != IPERatioCustomize.AUTO) {
            sb.append("ipeRatioCustomize ", (Object)this.ipeRatioCustomize);
        }
        if (this.dynamicMediaDisabled) {
            sb.append("dynamicMediaDisabled", this.dynamicMediaDisabled);
        }
        if (this.webOptimizedImageDeliveryDisabled) {
            sb.append("webOptimizedImageDeliveryDisabled", this.webOptimizedImageDeliveryDisabled);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties", (Object)AemObjectReflectionToStringBuilder.filteredValueMap((ValueMap)this.properties));
        }
        return sb.build();
    }

    public MediaArgs clone() {
        MediaArgs clone = new MediaArgs();
        clone.mediaFormatOptions = (MediaFormatOption[])ArrayUtils.clone((Object[])this.mediaFormatOptions);
        clone.autoCrop = this.autoCrop;
        clone.fileExtensions = (String[])ArrayUtils.clone((Object[])this.fileExtensions);
        clone.enforceOutputFileExtension = this.enforceOutputFileExtension;
        clone.urlMode = this.urlMode;
        clone.fixedWidth = this.fixedWidth;
        clone.fixedHeight = this.fixedHeight;
        clone.download = this.download;
        clone.contentDispositionAttachment = this.contentDispositionAttachment;
        clone.altText = this.altText;
        clone.forceAltValueFromAsset = this.forceAltValueFromAsset;
        clone.decorative = this.decorative;
        clone.dummyImage = this.dummyImage;
        clone.dummyImageUrl = this.dummyImageUrl;
        clone.includeAssetAemRenditions = this.includeAssetAemRenditions;
        clone.includeAssetThumbnails = this.includeAssetThumbnails;
        clone.includeAssetWebRenditions = this.includeAssetWebRenditions;
        clone.imageSizes = this.imageSizes;
        clone.pictureSourceSets = (PictureSource[])ArrayUtils.clone((Object[])this.pictureSourceSets);
        clone.imageQualityPercentage = this.imageQualityPercentage;
        clone.dragDropSupport = this.dragDropSupport;
        clone.ipeRatioCustomize = this.ipeRatioCustomize;
        clone.dynamicMediaDisabled = this.dynamicMediaDisabled;
        clone.webOptimizedImageDeliveryDisabled = this.webOptimizedImageDeliveryDisabled;
        if (this.properties != null) {
            clone.properties = new ValueMapDecorator(new HashMap(this.properties));
        }
        return clone;
    }

    @ProviderType
    public static final class MediaFormatOption {
        private final MediaFormat mediaFormat;
        private final String mediaFormatName;
        private final boolean mandatory;

        public MediaFormatOption(@Nullable MediaFormat mediaFormat, boolean mandatory) {
            this.mediaFormat = mediaFormat;
            this.mediaFormatName = null;
            this.mandatory = mandatory;
        }

        public MediaFormatOption(@NotNull String mediaFormatName, boolean mandatory) {
            this.mediaFormat = null;
            this.mediaFormatName = mediaFormatName;
            this.mandatory = mandatory;
        }

        @Nullable
        public MediaFormat getMediaFormat() {
            return this.mediaFormat;
        }

        @Nullable
        public String getMediaFormatName() {
            return this.mediaFormatName;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return MediaFormatOption.mediaFormatToString(this.mediaFormat, this.mediaFormatName, this.mandatory);
        }

        @NotNull
        MediaFormatOption withMandatory(boolean newMandatory) {
            if (this.mediaFormat != null) {
                return new MediaFormatOption(this.mediaFormat, newMandatory);
            }
            return new MediaFormatOption(this.mediaFormatName, newMandatory);
        }

        static String mediaFormatToString(MediaFormat mediaFormat, String mediaFormatName, boolean mandatory) {
            StringBuilder sb = new StringBuilder();
            if (mediaFormat != null) {
                sb.append(mediaFormat.toString());
            } else if (mediaFormatName != null) {
                sb.append(mediaFormatName);
            }
            if (!mandatory) {
                sb.append("[?]");
            }
            return sb.toString();
        }
    }

    @ProviderType
    public static final class ImageSizes {
        @NotNull
        private final String sizes;
        @NotNull
        private final @NotNull WidthOption @NotNull [] widthOptions;

        public ImageSizes(@NotNull String sizes, long ... widths) {
            this.sizes = sizes;
            this.widthOptions = (WidthOption[])Arrays.stream(widths).distinct().mapToObj(width -> new WidthOption(width, true)).toArray(WidthOption[]::new);
        }

        public ImageSizes(@NotNull String sizes, WidthOption ... widthOptions) {
            this.sizes = sizes;
            this.widthOptions = widthOptions;
        }

        @NotNull
        public String getSizes() {
            return this.sizes;
        }

        public @NotNull WidthOption @Nullable [] getWidthOptions() {
            return this.widthOptions;
        }

        public boolean hasDensityDescriptors() {
            return StringUtils.isEmpty((CharSequence)this.sizes) && Arrays.stream(this.widthOptions).map(WidthOption::getDensity).anyMatch(Objects::nonNull);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
            sb.append("sizes", (Object)this.sizes);
            if (this.widthOptions != null && this.widthOptions.length > 0) {
                sb.append("widthOptions", (Object)StringUtils.join((Object[])this.widthOptions, (String)","));
            }
            return sb.build();
        }
    }

    @ProviderType
    public static final class PictureSource {
        private MediaFormat mediaFormat;
        private String mediaFormatName;
        private String media;
        private String sizes;
        private WidthOption[] widthOptions;

        public PictureSource(@NotNull MediaFormat mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        public PictureSource(@Nullable String mediaFormatName) {
            this.mediaFormatName = mediaFormatName;
        }

        @NotNull
        private static @NotNull WidthOption @NotNull [] toWidthOptions(long ... widths) {
            return (WidthOption[])Arrays.stream(widths).distinct().mapToObj(width -> new WidthOption(width, true)).toArray(WidthOption[]::new);
        }

        @Nullable
        public MediaFormat getMediaFormat() {
            return this.mediaFormat;
        }

        @Nullable
        public String getMediaFormatName() {
            return this.mediaFormatName;
        }

        public PictureSource widthOptions(WidthOption ... value) {
            this.widthOptions = value;
            return this;
        }

        public @NotNull WidthOption @Nullable [] getWidthOptions() {
            return this.widthOptions;
        }

        public PictureSource widths(long ... value) {
            this.widthOptions = PictureSource.toWidthOptions(value);
            return this;
        }

        public PictureSource sizes(@Nullable String value) {
            this.sizes = value;
            return this;
        }

        @Nullable
        public String getSizes() {
            return this.sizes;
        }

        public PictureSource media(@Nullable String value) {
            this.media = value;
            return this;
        }

        @Nullable
        public String getMedia() {
            return this.media;
        }

        public boolean hasDensityDescriptors() {
            return StringUtils.isEmpty((CharSequence)this.sizes) && Arrays.stream(this.widthOptions).map(WidthOption::getDensity).anyMatch(Objects::nonNull);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
            sb.append("mediaFormat", (Object)MediaFormatOption.mediaFormatToString(this.mediaFormat, this.mediaFormatName, true));
            if (this.media != null) {
                sb.append("media", (Object)this.media);
            }
            if (this.sizes != null) {
                sb.append("sizes", (Object)this.sizes);
            }
            if (this.widthOptions != null && this.widthOptions.length > 0) {
                sb.append("widthOptions", (Object)StringUtils.join((Object[])this.widthOptions, (String)","));
            }
            return sb.build();
        }
    }

    @ProviderType
    public static final class WidthOption {
        private final long width;
        private final boolean mandatory;
        private final String density;

        public WidthOption(long width) {
            this(width, null, true);
        }

        public WidthOption(long width, @Nullable String density) {
            this(width, density, true);
        }

        public WidthOption(long width, boolean mandatory) {
            this(width, null, mandatory);
        }

        public WidthOption(long width, @Nullable String density, boolean mandatory) {
            this.width = width;
            this.mandatory = mandatory;
            this.density = density;
        }

        public long getWidth() {
            return this.width;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        @Nullable
        public String getDensity() {
            return this.density;
        }

        @NotNull
        public String getWidthDescriptor() {
            return String.format("%dw", this.width);
        }

        @NotNull
        public String getDensityDescriptor() {
            if (StringUtils.isEmpty((CharSequence)this.density) || StringUtils.equalsIgnoreCase((CharSequence)this.density, (CharSequence)"1x")) {
                return "";
            }
            return this.density;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Long.toString(this.width));
            if (this.density != null) {
                sb.append(":").append(this.density);
            }
            if (!this.mandatory) {
                sb.append("?");
            }
            return sb.toString();
        }
    }
}

