/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media;

import io.wcm.handler.media.MediaArgs;
import io.wcm.wcm.commons.util.AemObjectReflectionToStringBuilder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MediaRequest {
    private final Resource resource;
    private final String mediaRef;
    private final MediaArgs mediaArgs;
    private final MediaPropertyNames mediaPropertyNames;
    private ValueMap resourceProperties;

    public MediaRequest(@NotNull Resource resource, @Nullable MediaArgs mediaArgs) {
        this(resource, null, mediaArgs, null);
    }

    public MediaRequest(@Nullable String mediaRef, @Nullable MediaArgs mediaArgs) {
        this(null, mediaRef, mediaArgs, null);
    }

    public MediaRequest(@Nullable Resource resource, @Nullable String mediaRef, @Nullable MediaArgs mediaArgs, @Nullable MediaPropertyNames mediaPropertyNames) {
        this.resource = resource;
        this.mediaRef = mediaRef;
        this.mediaArgs = mediaArgs != null ? mediaArgs : new MediaArgs();
        this.mediaPropertyNames = mediaPropertyNames != null ? mediaPropertyNames : new MediaPropertyNames();
    }

    @Nullable
    public Resource getResource() {
        return this.resource;
    }

    @Nullable
    public String getMediaRef() {
        return this.mediaRef;
    }

    @NotNull
    public MediaArgs getMediaArgs() {
        return this.mediaArgs;
    }

    @NotNull
    public MediaPropertyNames getMediaPropertyNames() {
        return this.mediaPropertyNames;
    }

    @NotNull
    public ValueMap getResourceProperties() {
        if (this.resourceProperties == null) {
            this.resourceProperties = new ValueMapDecorator(new HashMap());
            if (this.resource != null) {
                this.resourceProperties.putAll((Map)this.resource.getValueMap());
            }
        }
        return this.resourceProperties;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, io.wcm.wcm.commons.util.ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
        if (this.resource != null) {
            sb.append("resource", (Object)this.resource.getPath());
            sb.append("resourceProperties", (Object)AemObjectReflectionToStringBuilder.filteredValueMap((ValueMap)this.resource.getValueMap()));
        }
        if (this.mediaRef != null) {
            sb.append("mediaRef", (Object)this.mediaRef);
        }
        if (this.mediaArgs != null) {
            sb.append("mediaArgs", (Object)this.mediaArgs);
        }
        return sb.build();
    }

    public static final class MediaPropertyNames {
        private String refProperty;
        private String cropProperty;
        private String rotationProperty;
        private String mapProperty;

        public MediaPropertyNames refProperty(@Nullable String name) {
            this.refProperty = name;
            return this;
        }

        @Nullable
        public String getRefProperty() {
            return this.refProperty;
        }

        public MediaPropertyNames cropProperty(@Nullable String name) {
            this.cropProperty = name;
            return this;
        }

        @Nullable
        public String getCropProperty() {
            return this.cropProperty;
        }

        public MediaPropertyNames rotationProperty(@Nullable String name) {
            this.rotationProperty = name;
            return this;
        }

        @Nullable
        public String getRotationProperty() {
            return this.rotationProperty;
        }

        public MediaPropertyNames mapProperty(@Nullable String name) {
            this.mapProperty = name;
            return this;
        }

        @Nullable
        public String getMapProperty() {
            return this.mapProperty;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)io.wcm.wcm.commons.util.ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE);
        }
    }
}

