/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.format;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.format.Ratio;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MediaFormat
implements Comparable<MediaFormat> {
    private final String name;
    private final String label;
    private final String description;
    private final long width;
    private final long minWidth;
    private final long maxWidth;
    private final long height;
    private final long minHeight;
    private final long maxHeight;
    private final long minWidthHeight;
    private final double ratio;
    private final double ratioWidth;
    private final double ratioHeight;
    private final long fileSizeMax;
    private final String[] extensions;
    private final String renditionGroup;
    private final boolean download;
    private final boolean internal;
    private final int ranking;
    private final ValueMap properties;
    private String ratioDisplayString;
    private String combinedTitle;

    MediaFormat(String name, String label, String description, long width, long minWidth, long maxWidth, long height, long minHeight, long maxHeight, long minWidthHeight, double ratio, double ratioWidth, double ratioHeight, long fileSizeMax, String[] extensions, String renditionGroup, boolean download, boolean internal, int ranking, ValueMap properties) {
        this.name = name;
        this.label = label;
        this.description = description;
        this.width = width;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.height = height;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.minWidthHeight = minWidthHeight;
        this.ratio = ratio;
        this.ratioWidth = ratioWidth;
        this.ratioHeight = ratioHeight;
        this.fileSizeMax = fileSizeMax;
        this.extensions = extensions;
        this.renditionGroup = renditionGroup;
        this.download = download;
        this.internal = internal;
        this.ranking = ranking;
        this.properties = properties;
    }

    @JsonProperty(value="mediaFormat")
    @NotNull
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    @NotNull
    public String getLabel() {
        return StringUtils.defaultString((String)this.label, (String)this.name);
    }

    @JsonIgnore
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public long getWidth() {
        return this.width;
    }

    @JsonIgnore
    public long getMinWidth() {
        return this.minWidth;
    }

    @JsonIgnore
    public long getMaxWidth() {
        return this.maxWidth;
    }

    @JsonIgnore
    public long getHeight() {
        return this.height;
    }

    @JsonIgnore
    public long getMinHeight() {
        return this.minHeight;
    }

    @JsonIgnore
    public long getMaxHeight() {
        return this.maxHeight;
    }

    public long getMinWidthHeight() {
        return this.minWidthHeight;
    }

    @JsonIgnore
    public double getRatioWidthAsDouble() {
        return this.ratioWidth;
    }

    @JsonIgnore
    public double getRatioHeightAsDouble() {
        return this.ratioHeight;
    }

    @JsonIgnore
    public double getRatio() {
        if (this.ratio > 0.0) {
            return this.ratio;
        }
        if (this.ratioWidth > 0.0 && this.ratioHeight > 0.0) {
            return Ratio.get(this.ratioWidth, this.ratioHeight);
        }
        if (this.isFixedDimension() && this.width > 0L && this.height > 0L) {
            return Ratio.get(this.width, this.height);
        }
        return 0.0;
    }

    @JsonIgnore
    public String getRatioDisplayString() {
        if (!this.hasRatio()) {
            return null;
        }
        if (this.ratioDisplayString == null) {
            this.ratioDisplayString = MediaFormat.buildratioDisplayString(this);
        }
        return this.ratioDisplayString;
    }

    private static String buildratioDisplayString(MediaFormat mf) {
        Object ratioDisplayString = null;
        DecimalFormat decimal1Format = new DecimalFormat("0.#", DecimalFormatSymbols.getInstance(Locale.US));
        ratioDisplayString = mf.getRatioWidthAsDouble() > 0.0 && mf.getRatioHeightAsDouble() > 0.0 ? decimal1Format.format(mf.getRatioWidthAsDouble()) + ":" + decimal1Format.format(mf.getRatioHeightAsDouble()) : MediaFormat.guessHumanReadableRatioString(mf.getRatio(), decimal1Format);
        if (ratioDisplayString == null) {
            if (mf.isFixedDimension()) {
                ratioDisplayString = decimal1Format.format(mf.getWidth()) + ":" + decimal1Format.format(mf.getHeight());
            } else {
                DecimalFormat decimal3Format = new DecimalFormat("0.###", DecimalFormatSymbols.getInstance(Locale.US));
                ratioDisplayString = "R" + decimal3Format.format(mf.getRatio());
            }
        }
        return ratioDisplayString;
    }

    private static String guessHumanReadableRatioString(double ratio, NumberFormat numberFormat) {
        if (ratio > 0.0) {
            double height;
            long width;
            for (width = 1L; width <= 50L; ++width) {
                height = (double)width / ratio;
                if (!MediaFormat.isLong(height)) continue;
                return numberFormat.format(width) + ":" + numberFormat.format(height);
            }
            for (width = 1L; width <= 200L; ++width) {
                height = (double)width / 2.0 / ratio;
                if (!MediaFormat.isHalfLong(height)) continue;
                return numberFormat.format((double)width / 2.0) + ":" + numberFormat.format(height);
            }
        }
        return null;
    }

    private static boolean isLong(double value) {
        return Math.round(value * 10000.0) == Math.round(value) * 10000L;
    }

    private static boolean isHalfLong(double value) {
        return Math.round(value * 2.0 * 10000.0) == Math.round(value * 2.0) * 10000L;
    }

    @JsonIgnore
    public boolean hasRatio() {
        return this.getRatio() > 0.0;
    }

    @JsonIgnore
    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    @JsonIgnore
    public String[] getExtensions() {
        return this.extensions != null ? (String[])this.extensions.clone() : null;
    }

    @JsonIgnore
    public String getRenditionGroup() {
        return this.renditionGroup;
    }

    @JsonIgnore
    public boolean isDownload() {
        return this.download;
    }

    @JsonIgnore
    public boolean isInternal() {
        return this.internal;
    }

    @JsonIgnore
    public long getRanking() {
        return this.ranking;
    }

    @JsonIgnore
    public boolean isImage() {
        for (String extension : this.getExtensions()) {
            if (!MediaFileType.isImage(extension)) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public boolean isFixedWidth() {
        return this.getWidth() > 0L && this.getMinWidth() == 0L && this.getMaxWidth() == 0L;
    }

    @JsonIgnore
    public boolean isFixedHeight() {
        return this.getHeight() > 0L && this.getMinHeight() == 0L && this.getMaxHeight() == 0L;
    }

    @JsonIgnore
    public boolean isFixedDimension() {
        return this.isFixedWidth() && this.isFixedHeight();
    }

    @JsonIgnore
    public long getEffectiveMinWidth() {
        long widthMin = this.getMinWidth();
        if (widthMin == 0L) {
            widthMin = this.getWidth();
        }
        return widthMin;
    }

    @JsonIgnore
    public long getEffectiveMaxWidth() {
        long widthMax = this.getMaxWidth();
        if (widthMax == 0L) {
            widthMax = this.getWidth();
        }
        return widthMax;
    }

    @JsonIgnore
    public long getEffectiveMinHeight() {
        long heightMin = this.getMinHeight();
        if (heightMin == 0L) {
            heightMin = this.getHeight();
        }
        return heightMin;
    }

    @JsonIgnore
    public long getEffectiveMaxHeight() {
        long heightMax = this.getMaxHeight();
        if (heightMax == 0L) {
            heightMax = this.getHeight();
        }
        return heightMax;
    }

    @JsonIgnore
    public Dimension getMinDimension() {
        long effWithMin = this.getEffectiveMinWidth();
        long effHeightMin = this.getEffectiveMinHeight();
        double effRatio = this.getRatio();
        if (effWithMin == 0L && effHeightMin > 0L && effRatio > 0.0) {
            effWithMin = Math.round((double)effHeightMin * effRatio);
        }
        if (effWithMin > 0L && effHeightMin == 0L && effRatio > 0.0) {
            effHeightMin = Math.round((double)effWithMin / effRatio);
        }
        if (effWithMin > 0L || effHeightMin > 0L) {
            return new Dimension(effWithMin, effHeightMin);
        }
        return null;
    }

    @JsonIgnore
    String getCombinedTitle() {
        if (this.combinedTitle == null) {
            String ratioString;
            StringBuilder sb = new StringBuilder();
            sb.append(this.getLabel());
            ArrayList<Object> extParts = new ArrayList<Object>();
            if (this.minWidthHeight != 0L) {
                extParts.add("min. " + this.minWidthHeight + "px width/height");
            } else {
                long widthMin = this.getEffectiveMinWidth();
                long widthMax = this.getEffectiveMaxWidth();
                long heightMin = this.getEffectiveMinHeight();
                long heightMax = this.getEffectiveMaxHeight();
                if (widthMin > 0L || widthMax > 0L || heightMin > 0L || heightMax > 0L) {
                    StringBuilder sbRestrictions = new StringBuilder();
                    if (widthMin == widthMax) {
                        if (widthMin == 0L) {
                            sbRestrictions.append("?");
                        } else {
                            sbRestrictions.append(widthMin);
                        }
                    } else {
                        if (widthMin > 0L) {
                            sbRestrictions.append(widthMin);
                        }
                        sbRestrictions.append("..");
                        if (widthMax > 0L) {
                            sbRestrictions.append(widthMax);
                        }
                    }
                    sbRestrictions.append('x');
                    if (heightMin == heightMax) {
                        if (heightMin == 0L) {
                            sbRestrictions.append("?");
                        } else {
                            sbRestrictions.append(heightMin);
                        }
                    } else {
                        if (heightMin > 0L) {
                            sbRestrictions.append(heightMin);
                        }
                        sbRestrictions.append("..");
                        if (heightMax > 0L) {
                            sbRestrictions.append(heightMax);
                        }
                    }
                    sbRestrictions.append("px");
                    extParts.add(sbRestrictions.toString());
                }
            }
            if (this.hasRatio() && !StringUtils.contains((CharSequence)this.getLabel(), (CharSequence)":") && StringUtils.isNotEmpty((CharSequence)(ratioString = this.getRatioDisplayString()))) {
                extParts.add(ratioString);
            }
            int MAX_EXTENSIONS = 6;
            StringBuilder extensionsString = new StringBuilder();
            String[] extensionList = this.getExtensions();
            if (extensionList != null) {
                for (int i = 0; i < extensionList.length && i < 6; ++i) {
                    if (i > 0) {
                        extensionsString.append(',');
                    }
                    extensionsString.append(extensionList[i]);
                }
                if (extensionList.length > 6) {
                    extensionsString.append("...");
                }
                if (extensionList.length > 0) {
                    extParts.add(extensionsString.toString());
                }
            }
            if (!extParts.isEmpty()) {
                sb.append(" (").append(StringUtils.join(extParts, (String)"; ")).append(')');
            }
            this.combinedTitle = sb.toString();
        }
        return this.combinedTitle;
    }

    @JsonIgnore
    public ValueMap getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getCombinedTitle();
    }

    public boolean equals(Object pObj) {
        if (pObj instanceof MediaFormat) {
            MediaFormat other = (MediaFormat)pObj;
            return this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(MediaFormat o) {
        return this.name.compareTo(o.name);
    }
}

