/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.imagemap.impl;

import io.wcm.handler.media.imagemap.ImageMapArea;
import io.wcm.handler.media.imagemap.ImageMapParser;
import io.wcm.handler.media.imagemap.impl.ImageMapAreaImpl;
import io.wcm.handler.media.spi.ImageMapLinkResolver;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={ImageMapParser.class})
public class ImageMapParserImpl
implements ImageMapParser {
    @SlingObject
    private Resource resource;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private ImageMapLinkResolver linkResolver;

    @Override
    @Nullable
    public List<ImageMapArea> parseMap(@Nullable String mapString) {
        String[] areaStrings;
        if (StringUtils.isBlank((CharSequence)mapString)) {
            return null;
        }
        ArrayList<ImageMapArea> areas = new ArrayList<ImageMapArea>();
        for (String areaString : areaStrings = StringUtils.split((String)mapString, (String)"][")) {
            int coordinatesEndIndex = areaString.indexOf(41);
            if (coordinatesEndIndex < 0) continue;
            String shapeAndCoords = StringUtils.substring((String)areaString, (int)0, (int)(coordinatesEndIndex + 1));
            String shape = StringUtils.substringBefore((String)shapeAndCoords, (String)"(");
            String coordinates = StringUtils.substringBetween((String)shapeAndCoords, (String)"(", (String)")");
            String remaining = StringUtils.substring((String)areaString, (int)(coordinatesEndIndex + 1));
            String[] remainingTokens = StringUtils.split((String)remaining, (String)"|");
            if (StringUtils.isBlank((CharSequence)shape) || StringUtils.isBlank((CharSequence)coordinates) || remainingTokens.length <= 0) continue;
            String linkUrl = StringUtils.remove((String)remainingTokens[0], (String)"\"");
            String linkWindowTarget = remainingTokens.length > 1 ? StringUtils.remove((String)remainingTokens[1], (String)"\"") : "";
            String altText = remainingTokens.length > 2 ? StringUtils.remove((String)remainingTokens[2], (String)"\"") : "";
            String relativeCoordinates = remainingTokens.length > 3 ? remainingTokens[3] : "";
            relativeCoordinates = StringUtils.substringBetween((String)relativeCoordinates, (String)"(", (String)")");
            Object link = null;
            if (this.linkResolver != null && (link = (Object)this.linkResolver.resolveLink(linkUrl, linkWindowTarget, this.resource)) != null) {
                linkUrl = this.linkResolver.getLinkUrl(link);
            }
            if (linkUrl == null || StringUtils.isBlank((CharSequence)linkUrl)) continue;
            ImageMapAreaImpl area = new ImageMapAreaImpl(shape, coordinates, StringUtils.trimToNull((String)relativeCoordinates), link, linkUrl, StringUtils.trimToNull((String)linkWindowTarget), StringUtils.trimToNull((String)altText));
            areas.add(area);
        }
        if (areas.isEmpty()) {
            return null;
        }
        return areas;
    }
}

