/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import io.wcm.handler.media.impl.JcrBinary;
import io.wcm.sling.commons.request.RequestPath;
import io.wcm.wcm.commons.caching.CacheHeader;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractMediaFileServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;

    AbstractMediaFileServlet() {
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = this.getBinaryDataResource(request);
        if (resource == null) {
            response.sendError(404);
            return;
        }
        if (this.isNotModified(resource, request, response)) {
            return;
        }
        byte[] binaryData = this.getBinaryData(resource, request);
        if (binaryData == null || binaryData.length == 0) {
            response.sendError(404);
        } else {
            String contentType = this.getContentType(resource, request);
            this.sendBinaryData(binaryData, contentType, request, response);
        }
    }

    @Nullable
    protected Resource getBinaryDataResource(SlingHttpServletRequest request) {
        return request.getResource();
    }

    protected boolean isNotModified(@NotNull Resource resource, @NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        return CacheHeader.isNotModified((Resource)resource, (SlingHttpServletRequest)request, (SlingHttpServletResponse)response, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte @Nullable [] getBinaryData(@NotNull Resource resource, @NotNull SlingHttpServletRequest request) throws IOException {
        InputStream is = (InputStream)resource.adaptTo(InputStream.class);
        if (is == null) {
            return null;
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            is.close();
        }
    }

    @NotNull
    protected String getContentType(@NotNull Resource resource, @NotNull SlingHttpServletRequest request) {
        String mimeType = JcrBinary.getMimeType(resource);
        if (StringUtils.isEmpty((CharSequence)mimeType)) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    protected void sendBinaryData(byte @NotNull [] binaryData, @NotNull String contentType, @NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        response.setContentType(contentType);
        response.setContentLength(binaryData.length);
        if (RequestPath.hasSelector((SlingHttpServletRequest)request, (String)"download_attachment")) {
            response.setContentType("application/x-download");
            this.setContentDispositionAttachmentHeader(request, response);
        }
        if (StringUtils.equals((CharSequence)contentType, (CharSequence)"image/svg+xml")) {
            this.setSVGContentSecurityPolicy(response);
        }
        ServletOutputStream out = response.getOutputStream();
        out.write(binaryData);
        out.flush();
    }

    private void setContentDispositionAttachmentHeader(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        StringBuilder dispositionHeader = new StringBuilder("attachment;");
        String suffix = request.getRequestPathInfo().getSuffix();
        if (StringUtils.isNotEmpty((CharSequence)(suffix = StringUtils.stripStart((String)suffix, (String)"/")))) {
            dispositionHeader.append("filename=\"").append(suffix).append('\"');
        }
        response.setHeader("Content-Disposition", dispositionHeader.toString());
    }

    protected void setSVGContentSecurityPolicy(@NotNull SlingHttpServletResponse response) {
        response.setHeader("Content-Security-Policy", "sandbox");
    }
}

