/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={Filter.class}, name="com.day.cq.dam.core.impl.servlet.DamContentDispositionFilter", property={"sling.filter.scope=request", "sling.filter.pattern=/content/dam/.*/(jcr:content|_jcr_content)/renditions/.*", "service.ranking=-25001"})
public final class AssetRenditionContentDispositionFilter
implements Filter {
    static final String BLACK_LIST_MIME_TYPE_CONFIG = "cq.mime.type.blacklist";
    static final String ALLOW_EMPTY_MIME = "cq.dam.empty.mime";
    private Set<String> mimetypeBlacklist;
    private boolean allowEmptyMime;

    @Activate
    private void activate(Map<String, Object> config) {
        String[] mimetypeBlacklistArray = PropertiesUtil.toStringArray((Object)config.get(BLACK_LIST_MIME_TYPE_CONFIG));
        this.mimetypeBlacklist = mimetypeBlacklistArray != null ? Arrays.stream(mimetypeBlacklistArray).map(StringUtils::lowerCase).collect(Collectors.toSet()) : Collections.emptySet();
        this.allowEmptyMime = PropertiesUtil.toBoolean((Object)config.get(ALLOW_EMPTY_MIME), (boolean)false);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
        if (this.accepts(slingRequest)) {
            this.setContentDisposition(slingRequest, slingResponse);
        }
        filterChain.doFilter(request, response);
    }

    private void setContentDisposition(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Resource resource = request.getResource();
        String mimeType = (String)resource.getValueMap().get("jcr:content/jcr:mimeType", String.class);
        if (StringUtils.isNotBlank((CharSequence)mimeType) && !this.mimetypeBlacklist.contains(mimeType.toLowerCase()) || StringUtils.isBlank((CharSequence)mimeType) && this.allowEmptyMime) {
            response.setHeader("Content-Disposition", "inline");
        }
    }

    private boolean accepts(SlingHttpServletRequest request) {
        return StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)"GET") && request.getResource() != null && StringUtils.equals((CharSequence)((CharSequence)request.getResource().getValueMap().get("jcr:primaryType", String.class)), (CharSequence)"nt:file");
    }

    public void destroy() {
    }
}

