/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import com.day.cq.wcm.commons.AbstractImageServlet;
import com.day.image.Font;
import com.day.image.Layer;
import com.day.image.font.AbstractFont;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.url.suffix.SuffixParser;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=png", "sling.servlet.resourceTypes=/apps/wcm-io/handler/media/components/dummyImage"})
public final class DummyImageServlet
extends AbstractImageServlet {
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final String PATH = "/apps/wcm-io/handler/media/content/dummyImage";
    @NotNull
    public static final String SUFFIX_WIDTH = "width";
    @NotNull
    public static final String SUFFIX_HEIGHT = "height";
    @NotNull
    public static final String SUFFIX_MEDIA_FORMAT_NAME = "mf";

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    protected Layer createLayer(AbstractImageServlet.ImageContext ctx) throws RepositoryException, IOException {
        SuffixParser parser = new SuffixParser(ctx.request);
        int width = (Integer)parser.get(SUFFIX_WIDTH, (Object)0);
        int height = (Integer)parser.get(SUFFIX_HEIGHT, (Object)0);
        String name = (String)parser.get(SUFFIX_MEDIA_FORMAT_NAME, String.class);
        if (width < 1 || height < 1) {
            return new Layer(1, 1, null);
        }
        Layer textLayer = this.getTextLayer(width, height, name);
        int x = (width - textLayer.getWidth()) / 2;
        int y = (height - textLayer.getHeight()) / 2;
        Layer layer = new Layer(width, height, (Paint)Color.GRAY);
        int backgroundOffset = width / 120;
        Layer textBackground = new Layer(textLayer.getWidth() + backgroundOffset * 2, textLayer.getHeight() + backgroundOffset * 2, (Paint)Color.DARK_GRAY);
        layer.blit(textBackground, x - backgroundOffset, y - backgroundOffset, textBackground.getWidth(), textBackground.getHeight(), 0, 0);
        layer.blit(textLayer, x, y, textLayer.getWidth(), textLayer.getHeight(), 0, 0);
        return layer;
    }

    private Layer getTextLayer(int width, int height, String name) {
        String text = (String)(StringUtils.isNotEmpty((CharSequence)name) ? name + "\n" : "") + width + " x " + height;
        Font font = new Font("Arial", width / 30);
        int align = 65553;
        Layer ret = new Layer(1, 1, null);
        ret.setPaint((Paint)Color.WHITE);
        ret.drawText(0, 0, 0, 0, text, (AbstractFont)font, align, 0.0, 0);
        return ret;
    }

    protected boolean checkModifiedSince(SlingHttpServletRequest pReq, SlingHttpServletResponse pResp) {
        return false;
    }
}

