/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.image.Layer;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.impl.AbstractMediaFileServlet;
import io.wcm.handler.media.impl.ImageFileServletSelector;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.media.impl.ResourceLayerUtil;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=file", "sling.servlet.selectors=image_file", "sling.servlet.resourceTypes=nt:file", "sling.servlet.resourceTypes=nt:resource", "sling.servlet.methods=GET"})
public final class ImageFileServlet
extends AbstractMediaFileServlet {
    private static final long serialVersionUID = 1L;
    public static final String SELECTOR = "image_file";
    @Reference
    private AssetStore assetStore;

    @Override
    protected byte @Nullable [] getBinaryData(@NotNull Resource resource, @NotNull SlingHttpServletRequest request) throws IOException {
        MediaHandlerConfig config = (MediaHandlerConfig)AdaptTo.notNull((Adaptable)request, MediaHandlerConfig.class);
        ImageFileServletSelector params = new ImageFileServletSelector(request.getRequestPathInfo().getSelectors());
        int width = params.getWidth();
        int height = params.getHeight();
        CropDimension cropDimension = params.getCropDimension();
        int rotation = params.getRotation();
        int quality = params.getQuality();
        if (width < 0 || height < 0 || width == 0 && height == 0) {
            return null;
        }
        Layer layer = ResourceLayerUtil.toLayer(resource, this.assetStore);
        if (layer == null) {
            return null;
        }
        double originalRatio = cropDimension != null ? Ratio.get(cropDimension) : Ratio.get(layer.getWidth(), layer.getHeight());
        if (width == 0) {
            width = (int)Math.round((double)height * originalRatio);
        } else if (height == 0) {
            height = (int)Math.round((double)width / originalRatio);
        }
        if (cropDimension != null) {
            layer.crop(cropDimension.getRectangle());
        } else {
            double requestedRatio = Ratio.get(width, height);
            if (!Ratio.matches(originalRatio, requestedRatio)) {
                cropDimension = ImageTransformation.calculateAutoCropDimension(layer.getWidth(), layer.getHeight(), requestedRatio);
                layer.crop(cropDimension.getRectangle());
            }
        }
        if (rotation != 0) {
            layer.rotate((double)rotation);
        }
        if (width <= layer.getWidth() && height <= layer.getHeight()) {
            layer.resize(width, height);
        }
        String contentType = this.getContentType(resource, request);
        double layerQuality = quality > 0 ? (double)quality / 100.0 : config.getDefaultImageQuality(contentType);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        layer.write(contentType, layerQuality, (OutputStream)bos);
        bos.flush();
        return bos.toByteArray();
    }

    @Override
    @NotNull
    protected String getContentType(@NotNull Resource resource, @NotNull SlingHttpServletRequest request) {
        String fileExtension;
        String fileName = request.getRequestPathInfo().getSuffix();
        if (StringUtils.isNotEmpty((CharSequence)fileName) && StringUtils.equalsIgnoreCase((CharSequence)(fileExtension = StringUtils.substringAfterLast((String)fileName, (String)".")), (CharSequence)"png")) {
            return "image/png";
        }
        return "image/jpeg";
    }

    public static String getImageFileName(@NotNull String originalFilename) {
        return ImageFileServlet.getImageFileName(originalFilename, null);
    }

    public static String getImageFileName(@NotNull String originalFilename, @Nullable String enforceOutputFileExtension) {
        String namePart = StringUtils.substringBeforeLast((String)originalFilename, (String)".");
        String extensionPart = StringUtils.substringAfterLast((String)originalFilename, (String)".");
        if (enforceOutputFileExtension != null) {
            extensionPart = enforceOutputFileExtension;
        }
        extensionPart = StringUtils.equalsIgnoreCase((CharSequence)extensionPart, (CharSequence)"png") ? "png" : "jpg";
        return namePart + "." + extensionPart;
    }
}

