/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import org.jetbrains.annotations.NotNull;

public final class ImageQualityPercentage {
    private ImageQualityPercentage() {
    }

    public static double get(@NotNull MediaArgs mediaArgs, @NotNull MediaHandlerConfig mediaHandlerConfig) {
        Double quality = mediaArgs.getImageQualityPercentage();
        if (quality == null) {
            quality = mediaHandlerConfig.getDefaultImageQualityPercentage();
        }
        return quality;
    }

    public static int getAsInteger(@NotNull MediaArgs mediaArgs, @NotNull MediaHandlerConfig mediaHandlerConfig) {
        double quality = ImageQualityPercentage.get(mediaArgs, mediaHandlerConfig);
        return (int)Math.round(quality * 100.0);
    }
}

