/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import io.wcm.handler.media.impl.AbstractMediaFileServlet;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=file", "sling.servlet.selectors=media_file", "sling.servlet.resourceTypes=nt:file", "sling.servlet.resourceTypes=nt:resource", "sling.servlet.methods=GET"})
@Designate(ocd=Config.class)
public final class MediaFileServlet
extends AbstractMediaFileServlet {
    private static final long serialVersionUID = 1L;
    private boolean svgContentSecurityPolicy;

    @Activate
    private void activate(Config config) {
        this.svgContentSecurityPolicy = config.svgContentSecurityPolicy();
    }

    @Override
    protected void setSVGContentSecurityPolicy(@NotNull SlingHttpServletResponse response) {
        if (this.svgContentSecurityPolicy) {
            super.setSVGContentSecurityPolicy(response);
        }
    }

    @ObjectClassDefinition(name="wcm.io Media Handler Media File Servlet", description="Configures delivery of media file binaries.")
    static @interface Config {
        @AttributeDefinition(name="SVG Content Security Policy", description="Apply XSS protection when serving SVG files by setting Content-Security-Policy to 'sandbox'.")
        public boolean svgContentSecurityPolicy() default true;
    }
}

