/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaBuilder;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.media.MediaInvalidReason;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.handler.media.impl.MediaBuilderImpl;
import io.wcm.handler.media.impl.MediaFormatResolver;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.media.spi.MediaMarkupBuilder;
import io.wcm.handler.media.spi.MediaProcessor;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.commons.component.ComponentPropertyResolverFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={MediaHandler.class})
public final class MediaHandlerImpl
implements MediaHandler {
    @Self
    private Adaptable adaptable;
    @Self
    private MediaHandlerConfig mediaHandlerConfig;
    @Self
    private MediaFormatHandler mediaFormatHandler;
    @OSGiService
    private ComponentPropertyResolverFactory componentPropertyResolverFactory;
    private static final Logger log = LoggerFactory.getLogger(MediaHandlerImpl.class);

    @Override
    @NotNull
    public MediaBuilder get(@Nullable Resource resource) {
        return new MediaBuilderImpl(resource, this, this.componentPropertyResolverFactory);
    }

    @Override
    @NotNull
    public MediaBuilder get(@Nullable Resource resource, @NotNull MediaArgs mediaArgs) {
        return this.get(resource).args(mediaArgs);
    }

    @Override
    @NotNull
    public MediaBuilder get(@Nullable Resource resource, MediaFormat ... mediaFormats) {
        return this.get(resource).mediaFormats(mediaFormats);
    }

    @Override
    @NotNull
    public MediaBuilder get(@Nullable String mediaRef) {
        return new MediaBuilderImpl(mediaRef, null, this, this.componentPropertyResolverFactory);
    }

    @Override
    @NotNull
    public MediaBuilder get(@Nullable String mediaRef, @Nullable Resource contextResource) {
        return new MediaBuilderImpl(mediaRef, contextResource, this, this.componentPropertyResolverFactory);
    }

    @Override
    @NotNull
    public MediaBuilder get(@Nullable String mediaRef, @NotNull MediaArgs mediaArgs) {
        return this.get(mediaRef).args(mediaArgs);
    }

    @Override
    @NotNull
    public MediaBuilder get(@Nullable String mediaRef, MediaFormat ... mediaFormats) {
        return this.get(mediaRef).mediaFormats(mediaFormats);
    }

    @Override
    @NotNull
    public MediaBuilder get(@NotNull MediaRequest mediaRequest) {
        return new MediaBuilderImpl(mediaRequest, this);
    }

    @NotNull
    @SuppressFBWarnings(value={"STYLE"})
    Media processRequest(@NotNull MediaRequest mediaRequest) {
        List<Class<? extends MediaProcessor>> mediaPreProcessors;
        MediaSource mediaSource = null;
        List<Class<? extends MediaSource>> mediaSources = this.mediaHandlerConfig.getSources();
        if (mediaSources == null || mediaSources.isEmpty()) {
            throw new RuntimeException("No media sources defined.");
        }
        MediaSource firstMediaSource = null;
        for (Class<? extends MediaSource> candidateMediaSourceClass : mediaSources) {
            MediaSource candidateMediaSource = (MediaSource)AdaptTo.notNull((Adaptable)this.adaptable, candidateMediaSourceClass);
            if (candidateMediaSource.accepts(mediaRequest)) {
                mediaSource = candidateMediaSource;
                break;
            }
            if (firstMediaSource != null) continue;
            firstMediaSource = candidateMediaSource;
        }
        if (mediaSource == null) {
            mediaSource = firstMediaSource;
        }
        Media media = new Media(mediaSource, mediaRequest);
        MediaFormatResolver mediaFormatResolver = new MediaFormatResolver(this.mediaFormatHandler);
        if (!mediaFormatResolver.resolve(mediaRequest.getMediaArgs())) {
            media.setMediaInvalidReason(MediaInvalidReason.INVALID_MEDIA_FORMAT);
            return media;
        }
        if (!this.resolveDownloadMediaFormats(mediaRequest.getMediaArgs())) {
            media.setMediaInvalidReason(MediaInvalidReason.INVALID_MEDIA_FORMAT);
            return media;
        }
        if (mediaRequest.getMediaArgs().getIncludeAssetAemRenditions() == null) {
            mediaRequest.getMediaArgs().includeAssetAemRenditions(this.mediaHandlerConfig.getIncludeAssetAemRenditionsByDefault());
        }
        if (log.isTraceEnabled()) {
            log.trace("Start processing media request (mediaSource={}): {}", (Object)mediaSource.getId(), (Object)mediaRequest);
        }
        if ((mediaPreProcessors = this.mediaHandlerConfig.getPreProcessors()) != null) {
            for (Class<? extends MediaProcessor> processorClass : mediaPreProcessors) {
                log.trace("Apply pre processor ({}): {}", processorClass, (Object)mediaRequest);
                MediaProcessor processor = (MediaProcessor)AdaptTo.notNull((Adaptable)this.adaptable, processorClass);
                media = processor.process(media);
                if (media != null) continue;
                throw new RuntimeException("MediaPreProcessor '" + String.valueOf(processor) + "' returned null, request: " + String.valueOf(mediaRequest));
            }
        }
        if (media.getMediaInvalidReason() == null) {
            List<Class<? extends MediaProcessor>> mediaPostProcessors;
            if ((media = mediaSource.resolveMedia(media)) == null) {
                throw new RuntimeException("MediaType '" + String.valueOf(mediaSource) + "' returned null, request: " + String.valueOf(mediaRequest));
            }
            List<Class<? extends MediaMarkupBuilder>> mediaMarkupBuilders = this.mediaHandlerConfig.getMarkupBuilders();
            if (mediaMarkupBuilders != null) {
                media.setElementBuilder(m -> {
                    for (Class mediaMarkupBuilderClass : mediaMarkupBuilders) {
                        MediaMarkupBuilder mediaMarkupBuilder = (MediaMarkupBuilder)AdaptTo.notNull((Adaptable)this.adaptable, (Class)mediaMarkupBuilderClass);
                        if (!mediaMarkupBuilder.accepts((Media)m)) continue;
                        log.trace("Apply media markup builder ({}): {}", (Object)mediaMarkupBuilderClass, (Object)mediaRequest);
                        return mediaMarkupBuilder.build((Media)m);
                    }
                    return null;
                });
            }
            if ((mediaPostProcessors = this.mediaHandlerConfig.getPostProcessors()) != null) {
                for (Class<? extends MediaProcessor> processorClass : mediaPostProcessors) {
                    log.trace("Apply post processor ({}): {}", processorClass, (Object)mediaRequest);
                    MediaProcessor processor = (MediaProcessor)AdaptTo.notNull((Adaptable)this.adaptable, processorClass);
                    media = processor.process(media);
                    if (media != null) continue;
                    throw new RuntimeException("MediaPostProcessor '" + String.valueOf(processor) + "' returned null, request: " + String.valueOf(mediaRequest));
                }
            }
        } else {
            log.trace("Skip media resolving because media was set to invalid by prepocessor. reason={}, message={}", (Object)media.getMediaInvalidReason(), (Object)media.getMediaInvalidReasonCustomMessage());
        }
        log.debug("Finished media processing: {}", (Object)media);
        return media;
    }

    @Override
    public boolean isValidElement(HtmlElement element) {
        if (element == null) {
            return false;
        }
        List<Class<? extends MediaMarkupBuilder>> mediaMarkupBuilders = this.mediaHandlerConfig.getMarkupBuilders();
        if (mediaMarkupBuilders != null) {
            for (Class<? extends MediaMarkupBuilder> mediaMarkupBuilderClass : mediaMarkupBuilders) {
                MediaMarkupBuilder mediaMarkupBuilder = (MediaMarkupBuilder)AdaptTo.notNull((Adaptable)this.adaptable, mediaMarkupBuilderClass);
                if (!mediaMarkupBuilder.isValidMedia(element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean resolveDownloadMediaFormats(MediaArgs mediaArgs) {
        if (!mediaArgs.isDownload()) {
            return true;
        }
        ArrayList<MediaFormat> candidates = new ArrayList<MediaFormat>();
        boolean fallbackToAllMediaFormats = false;
        if (mediaArgs.getMediaFormats() != null) {
            candidates.addAll(List.of(mediaArgs.getMediaFormats()));
        } else {
            candidates.addAll(this.mediaFormatHandler.getMediaFormats());
            fallbackToAllMediaFormats = true;
        }
        MediaFormat[] result = (MediaFormat[])candidates.stream().filter(MediaFormat::isDownload).toArray(MediaFormat[]::new);
        if (result.length > 0) {
            mediaArgs.mediaFormats(result);
            return true;
        }
        return fallbackToAllMediaFormats;
    }

    @Override
    public Media invalid() {
        Class mediaSourceClass = this.mediaHandlerConfig.getSources().stream().findFirst().orElse(null);
        if (mediaSourceClass == null) {
            throw new RuntimeException("No media sources defined.");
        }
        MediaSource mediaSource = (MediaSource)AdaptTo.notNull((Adaptable)this.adaptable, (Class)mediaSourceClass);
        Media media = new Media(mediaSource, new MediaRequest((String)null, null));
        media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_MISSING);
        return media;
    }
}

