/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.media.MediaArgs;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WidthUtils {
    static final String WIDTH_OPTION = "\\d+(:\\d+(\\.\\d+)?x)?\\??";
    static final Pattern WIDTH_OPTION_PATTERN = Pattern.compile("(?<width>\\d+)(:(?<density>\\d+(\\.\\d+)?x))?(?<optional>\\?)?");
    static final Pattern WIDTHS_PATTERN = Pattern.compile("^\\s*\\d+(:\\d+(\\.\\d+)?x)?\\??\\s*(,\\s*\\d+(:\\d+(\\.\\d+)?x)?\\??\\s*)*+$");

    private WidthUtils() {
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    public static @NotNull MediaArgs.WidthOption @Nullable [] parseWidths(@Nullable String widths) {
        if (StringUtils.isBlank((CharSequence)widths)) {
            return null;
        }
        if (!WIDTHS_PATTERN.matcher(widths).matches()) {
            return null;
        }
        String[] widthItems = StringUtils.split((String)widths, (String)",");
        return (MediaArgs.WidthOption[])Arrays.stream(widthItems).map(StringUtils::trim).map(WidthUtils::toWidthOption).filter(Objects::nonNull).toArray(MediaArgs.WidthOption[]::new);
    }

    @Nullable
    private static MediaArgs.WidthOption toWidthOption(@NotNull String widthOptionString) {
        Matcher widthOptionMatcher = WIDTH_OPTION_PATTERN.matcher(widthOptionString);
        if (!widthOptionMatcher.matches()) {
            return null;
        }
        long width = NumberUtils.toLong((String)widthOptionMatcher.group("width"));
        String density = widthOptionMatcher.group("density");
        boolean mandatory = widthOptionMatcher.group("optional") == null;
        return new MediaArgs.WidthOption(width, density, mandatory);
    }

    public static boolean hasDensityDescriptor(@Nullable String widths) {
        if (StringUtils.isBlank((CharSequence)widths) || !WIDTHS_PATTERN.matcher(widths).matches()) {
            return false;
        }
        return StringUtils.contains((CharSequence)widths, (CharSequence)":");
    }
}

