/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl.ipeconfig;

import io.wcm.handler.media.format.MediaFormat;
import io.wcm.sling.commons.resource.ImmutableValueMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AspectRatioResource
extends AbstractResource {
    private static final String RESOURCE_TYPE = "wcm-io/handler/media/synthetic/resource/aspectRatio";
    private final ResourceResolver resolver;
    private final String path;
    private final ResourceMetadata resourceMetadata;
    private final ValueMap properties;

    AspectRatioResource(ResourceResolver resolver, MediaFormat mediaFormat, String path) {
        this.resolver = resolver;
        this.path = path;
        this.resourceMetadata = AspectRatioResource.buildMetadata(path);
        double ratio = 0.0;
        if (mediaFormat.getRatio() > 0.0) {
            ratio = 1.0 / mediaFormat.getRatio();
        }
        this.properties = ImmutableValueMap.of((String)"name", (Object)AspectRatioResource.getDisplayString(mediaFormat), (String)"ratio", (Object)ratio);
    }

    private static String getDisplayString(MediaFormat mf) {
        if (StringUtils.contains((CharSequence)mf.getName(), (CharSequence)":")) {
            return mf.getName();
        }
        String ratioDisplayString = mf.getRatioDisplayString();
        if (ratioDisplayString != null) {
            return mf.getLabel() + " (" + mf.getRatioDisplayString() + ")";
        }
        return mf.getLabel();
    }

    private static ResourceMetadata buildMetadata(String path) {
        ResourceMetadata metadata = new ResourceMetadata();
        metadata.setResolutionPath(path);
        return metadata;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    @NotNull
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Nullable
    public String getResourceSuperType() {
        return null;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.properties;
        }
        return (AdapterType)super.adaptTo(type);
    }
}

