/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.markup;

import com.day.cq.wcm.api.WCMMode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Image;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.markup.AbstractImageMediaMarkupBuilder;
import io.wcm.handler.media.markup.MediaMarkupBuilderUtil;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class DummyImageMediaMarkupBuilder
extends AbstractImageMediaMarkupBuilder {
    @Self
    private Adaptable adaptable;
    @Self
    private UrlHandler urlHandler;
    @Self
    private MediaHandlerConfig mediaHandlerConfig;

    @Override
    public boolean accepts(@NotNull Media media) {
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        MediaFormat[] mediaFormats = mediaArgs.getMediaFormats();
        return (!media.isValid() || media.getRendition() == null) && this.getWcmMode() != null && this.getWcmMode() != WCMMode.DISABLED && mediaFormats != null && mediaFormats.length > 0 && mediaArgs.isDummyImage();
    }

    @Override
    @SuppressFBWarnings(value={"STYLE"})
    public HtmlElement build(@NotNull Media media) {
        Dimension dimension = MediaMarkupBuilderUtil.getMediaformatDimension(media);
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        String dummyImageUrl = StringUtils.defaultString((String)mediaArgs.getDummyImageUrl(), (String)"/apps/wcm-io/handler/media/docroot/resources/img/media-dummy.png");
        dummyImageUrl = this.urlHandler.get(dummyImageUrl).urlMode(media.getMediaRequest().getMediaArgs().getUrlMode()).buildExternalResourceUrl();
        Image image = new Image(dummyImageUrl, dimension.getWidth(), dimension.getHeight()).addCssClass("wcmio_mediahandler_wcm_dummy");
        this.setAdditionalAttributes((HtmlElement)image, media);
        MediaSource mediaSource = media.getMediaSource();
        if (mediaSource == null && !this.mediaHandlerConfig.getSources().isEmpty()) {
            Class<? extends MediaSource> mediaSourceClass = this.mediaHandlerConfig.getSources().iterator().next();
            mediaSource = (MediaSource)AdaptTo.notNull((Adaptable)this.adaptable, mediaSourceClass);
        }
        if (mediaSource != null) {
            mediaSource.enableMediaDrop((HtmlElement)image, media.getMediaRequest());
        }
        return image;
    }

    @Override
    public boolean isValidMedia(@NotNull HtmlElement element) {
        return false;
    }
}

