/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.spi;

import io.wcm.handler.media.format.MediaFormat;
import io.wcm.sling.commons.caservice.ContextAwareService;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class MediaFormatProvider
implements ContextAwareService {
    private final Set<MediaFormat> mediaFormats;
    private static final Logger log = LoggerFactory.getLogger(MediaFormatProvider.class);

    protected MediaFormatProvider(Set<MediaFormat> mediaFormats) {
        this.mediaFormats = mediaFormats;
    }

    protected MediaFormatProvider(Class<?> type) {
        this(MediaFormatProvider.getMediaFormatsFromPublicFields(type));
    }

    @NotNull
    public Set<MediaFormat> getMediaFormats() {
        return this.mediaFormats;
    }

    private static Set<MediaFormat> getMediaFormatsFromPublicFields(Class<?> type) {
        HashSet<MediaFormat> params = new HashSet<MediaFormat>();
        try {
            Field[] fields;
            for (Field field : fields = type.getFields()) {
                if (!field.getType().isAssignableFrom(MediaFormat.class)) continue;
                params.add((MediaFormat)field.get(null));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            log.warn("Unable to access fields of {}", (Object)type.getName(), (Object)ex);
        }
        return Collections.unmodifiableSet(params);
    }

    @Deprecated(since="2.0.0")
    protected final void finalize() {
    }
}

