/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.spi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.imagemap.ImageMapArea;
import io.wcm.handler.media.imagemap.ImageMapParser;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class MediaSource {
    private static final Logger log = LoggerFactory.getLogger(MediaSource.class);

    @NotNull
    public abstract String getId();

    @Nullable
    public abstract String getPrimaryMediaRefProperty();

    public boolean accepts(@NotNull MediaRequest mediaRequest) {
        if (StringUtils.isNotEmpty((CharSequence)mediaRequest.getMediaRef())) {
            return this.accepts(mediaRequest.getMediaRef());
        }
        ValueMap props = mediaRequest.getResourceProperties();
        String mediaSourceId = (String)props.get("mediaSource", String.class);
        if (StringUtils.isNotEmpty((CharSequence)mediaSourceId)) {
            return StringUtils.equals((CharSequence)mediaSourceId, (CharSequence)this.getId());
        }
        String refProperty = StringUtils.defaultString((String)mediaRequest.getMediaPropertyNames().getRefProperty(), (String)this.getPrimaryMediaRefProperty());
        String mediaRef = (String)props.get(refProperty, String.class);
        return this.accepts(mediaRef);
    }

    public abstract boolean accepts(@Nullable String var1);

    @NotNull
    public abstract Media resolveMedia(@NotNull Media var1);

    public abstract void enableMediaDrop(@NotNull HtmlElement var1, @NotNull MediaRequest var2);

    public void setCustomIPECropRatios(@NotNull HtmlElement element, @NotNull MediaRequest mediaRequest) {
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @Nullable
    protected final String getMediaRef(@NotNull MediaRequest mediaRequest, @Nullable MediaHandlerConfig mediaHandlerConfig) {
        if (StringUtils.isNotEmpty((CharSequence)mediaRequest.getMediaRef())) {
            return mediaRequest.getMediaRef();
        }
        if (mediaRequest.getResource() != null) {
            String refProperty = this.getMediaRefProperty(mediaRequest, mediaHandlerConfig);
            return (String)mediaRequest.getResource().getValueMap().get(refProperty, String.class);
        }
        return null;
    }

    @NotNull
    protected final String getMediaRefProperty(@NotNull MediaRequest mediaRequest, @Nullable MediaHandlerConfig mediaHandlerConfig) {
        String refProperty = mediaRequest.getMediaPropertyNames().getRefProperty();
        if (StringUtils.isEmpty((CharSequence)refProperty)) {
            refProperty = mediaHandlerConfig != null ? mediaHandlerConfig.getMediaRefProperty() : "mediaRef";
        }
        return refProperty;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @Nullable
    protected final CropDimension getMediaCropDimension(@NotNull MediaRequest mediaRequest, @Nullable MediaHandlerConfig mediaHandlerConfig) {
        if (mediaRequest.getResource() != null) {
            String cropProperty = this.getMediaCropProperty(mediaRequest, mediaHandlerConfig);
            String cropString = (String)mediaRequest.getResource().getValueMap().get(cropProperty, String.class);
            if (StringUtils.isNotEmpty((CharSequence)cropString)) {
                try {
                    return CropDimension.fromCropString(cropString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @NotNull
    protected final String getMediaCropProperty(@NotNull MediaRequest mediaRequest, @Nullable MediaHandlerConfig mediaHandlerConfig) {
        String cropProperty = mediaRequest.getMediaPropertyNames().getCropProperty();
        if (StringUtils.isEmpty((CharSequence)cropProperty)) {
            cropProperty = mediaHandlerConfig != null ? mediaHandlerConfig.getMediaCropProperty() : "mediaCrop";
        }
        return cropProperty;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @Nullable
    protected final Integer getMediaRotation(@NotNull MediaRequest mediaRequest, @NotNull MediaHandlerConfig mediaHandlerConfig) {
        if (mediaRequest.getResource() != null) {
            int rotationValue;
            String rotationProperty = this.getMediaRotationProperty(mediaRequest, mediaHandlerConfig);
            String stringValue = (String)mediaRequest.getResource().getValueMap().get(rotationProperty, String.class);
            if (StringUtils.isNotEmpty((CharSequence)stringValue) && ImageTransformation.isValidRotation(rotationValue = NumberUtils.toInt((String)stringValue))) {
                return rotationValue;
            }
        }
        return null;
    }

    @NotNull
    protected final String getMediaRotationProperty(@NotNull MediaRequest mediaRequest, @NotNull MediaHandlerConfig mediaHandlerConfig) {
        String rotationProperty = mediaRequest.getMediaPropertyNames().getRotationProperty();
        if (StringUtils.isEmpty((CharSequence)rotationProperty)) {
            rotationProperty = mediaHandlerConfig.getMediaRotationProperty();
        }
        return rotationProperty;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @Nullable
    protected final List<ImageMapArea> getMediaMap(@NotNull MediaRequest mediaRequest, @NotNull MediaHandlerConfig mediaHandlerConfig) {
        if (mediaRequest.getResource() != null) {
            ImageMapParser imageMapParser;
            String mapProperty = this.getMediaMapProperty(mediaRequest, mediaHandlerConfig);
            String stringValue = (String)mediaRequest.getResource().getValueMap().get(mapProperty, String.class);
            if (StringUtils.isNotEmpty((CharSequence)stringValue) && (imageMapParser = (ImageMapParser)mediaRequest.getResource().adaptTo(ImageMapParser.class)) != null) {
                return imageMapParser.parseMap(stringValue);
            }
        }
        return null;
    }

    @NotNull
    protected final String getMediaMapProperty(@NotNull MediaRequest mediaRequest, @NotNull MediaHandlerConfig mediaHandlerConfig) {
        String mapProperty = mediaRequest.getMediaPropertyNames().getMapProperty();
        if (StringUtils.isEmpty((CharSequence)mapProperty)) {
            mapProperty = mediaHandlerConfig.getMediaMapProperty();
        }
        return mapProperty;
    }

    protected final void updateMediaArgsFromResource(@NotNull MediaArgs mediaArgs, @NotNull Resource resource, @NotNull MediaHandlerConfig mediaHandlerConfig) {
        ValueMap props = resource.getValueMap();
        if (StringUtils.isEmpty((CharSequence)mediaArgs.getAltText())) {
            mediaArgs.altText((String)props.get(mediaHandlerConfig.getMediaAltTextProperty(), String.class));
        }
        if (!mediaArgs.isDecorative()) {
            mediaArgs.decorative((Boolean)props.get(mediaHandlerConfig.getMediaIsDecorativeProperty(), (Object)false));
        }
        if (mediaArgs.isForceAltValueFromAsset()) {
            mediaArgs.forceAltValueFromAsset((Boolean)props.get(mediaHandlerConfig.getMediaForceAltTextFromAssetProperty(), (Object)true));
        }
    }

    protected final boolean resolveRenditions(Media media, Asset asset, MediaArgs mediaArgs) {
        boolean anyMandatory = mediaArgs.getMediaFormatOptions() != null && Arrays.stream(mediaArgs.getMediaFormatOptions()).anyMatch(MediaArgs.MediaFormatOption::isMandatory);
        MediaFormat[] mediaFormats = mediaArgs.getMediaFormats();
        if (mediaFormats != null && mediaFormats.length > 1 && (anyMandatory || mediaArgs.getImageSizes() != null || mediaArgs.getPictureSources() != null)) {
            return this.resolveAllRenditions(media, asset, mediaArgs);
        }
        return this.resolveFirstMatchRenditions(media, asset, mediaArgs);
    }

    private boolean resolveFirstMatchRenditions(Media media, Asset asset, MediaArgs mediaArgs) {
        Rendition rendition = asset.getRendition(mediaArgs);
        boolean renditionFound = false;
        if (rendition != null) {
            media.setRenditions(List.of(rendition));
            media.setUrl(rendition.getUrl());
            renditionFound = true;
        }
        log.trace("ResolveFirstMatchRenditions: renditionFound={}, rendition={}", (Object)renditionFound, (Object)rendition);
        return renditionFound;
    }

    private boolean resolveAllRenditions(@NotNull Media media, @NotNull Asset asset, @NotNull MediaArgs mediaArgs) {
        boolean anyResolved = false;
        ArrayList<Rendition> resolvedRenditions = new ArrayList<Rendition>();
        List<MediaArgs.MediaFormatOption> parentMediaFormatOptions = this.getParentMediaFormats(mediaArgs);
        boolean allMandatoryResolved = this.resolveRenditionsWithMediaFormats(asset, mediaArgs, parentMediaFormatOptions, resolvedRenditions);
        if (allMandatoryResolved) {
            List resolvedMediaFormats = !resolvedRenditions.isEmpty() ? resolvedRenditions.stream().map(Rendition::getMediaFormat).filter(Objects::nonNull).collect(Collectors.toList()) : parentMediaFormatOptions.stream().map(MediaArgs.MediaFormatOption::getMediaFormat).filter(Objects::nonNull).collect(Collectors.toList());
            for (MediaFormat mediaFormat : resolvedMediaFormats) {
                List<MediaArgs.MediaFormatOption> childMediaFormatOptions = this.getChildMediaFormats(mediaArgs, mediaFormat);
                allMandatoryResolved = this.resolveRenditionsWithMediaFormats(asset, mediaArgs, childMediaFormatOptions, resolvedRenditions) && allMandatoryResolved;
            }
        }
        media.setRenditions(resolvedRenditions);
        if (!resolvedRenditions.isEmpty()) {
            anyResolved = true;
            media.setUrl(((Rendition)resolvedRenditions.get(0)).getUrl());
        }
        log.trace("ResolveAllRenditions: anyResolved={}, allMandatoryResolved={}, resolvedRenditions={}", new Object[]{anyResolved, allMandatoryResolved, resolvedRenditions});
        return anyResolved && allMandatoryResolved;
    }

    private boolean resolveRenditionsWithMediaFormats(@NotNull Asset asset, @NotNull MediaArgs mediaArgs, @NotNull List<MediaArgs.MediaFormatOption> mediaFormatOptions, @NotNull List<Rendition> resolvedRenditions) {
        ArrayList<Rendition> fallbackRenditions = new ArrayList<Rendition>();
        boolean allMandatoryResolved = true;
        for (MediaArgs.MediaFormatOption mediaFormatOption : mediaFormatOptions) {
            MediaArgs renditionMediaArgs = mediaArgs.clone();
            renditionMediaArgs.mediaFormat(mediaFormatOption.getMediaFormat());
            Rendition rendition = asset.getRendition(renditionMediaArgs);
            if (rendition != null) {
                if (rendition.isFallback()) {
                    fallbackRenditions.add(rendition);
                    continue;
                }
                resolvedRenditions.add(rendition);
                continue;
            }
            if (!mediaFormatOption.isMandatory()) continue;
            allMandatoryResolved = false;
        }
        resolvedRenditions.addAll(fallbackRenditions);
        return allMandatoryResolved;
    }

    @NotNull
    private List<MediaArgs.MediaFormatOption> getParentMediaFormats(@NotNull MediaArgs mediaArgs) {
        return Arrays.stream(mediaArgs.getMediaFormatOptions()).filter(this::isParentMediaFormat).collect(Collectors.toList());
    }

    @NotNull
    private List<MediaArgs.MediaFormatOption> getChildMediaFormats(@NotNull MediaArgs mediaArgs, @NotNull MediaFormat parentMediaFormat) {
        return Arrays.stream(mediaArgs.getMediaFormatOptions()).filter(this::isChildMediaFormat).filter(childMediaFormat -> this.hasParent((MediaArgs.MediaFormatOption)childMediaFormat, parentMediaFormat)).collect(Collectors.toList());
    }

    private boolean isParentMediaFormat(@NotNull MediaArgs.MediaFormatOption mediaFormatOption) {
        return Objects.isNull(this.getParentMediaFormat(mediaFormatOption.getMediaFormat()));
    }

    private boolean isChildMediaFormat(@NotNull MediaArgs.MediaFormatOption mediaFormatOption) {
        return Objects.nonNull(this.getParentMediaFormat(mediaFormatOption.getMediaFormat()));
    }

    private boolean hasParent(@NotNull MediaArgs.MediaFormatOption childMediaFormat, @NotNull MediaFormat parentMediaFormat) {
        return parentMediaFormat.equals(this.getParentMediaFormat(childMediaFormat.getMediaFormat()));
    }

    @Nullable
    private MediaFormat getParentMediaFormat(@Nullable MediaFormat mediaFormat) {
        if (mediaFormat == null) {
            return null;
        }
        return (MediaFormat)mediaFormat.getProperties().get("parentMediaFormat", MediaFormat.class);
    }
}

