/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.ui;

import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaBuilder;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.handler.media.impl.WidthUtils;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ImageUtils.class);

    private ImageUtils() {
    }

    public static void applyPictureSources(@NotNull MediaFormatHandler mediaFormatHandler, @NotNull MediaBuilder builder, String @NotNull [] mediaFormatNames, String @NotNull [] medias, String @NotNull [] widths) {
        for (int i = 0; i < mediaFormatNames.length && i < medias.length && i < widths.length; ++i) {
            MediaFormat mediaFormat = mediaFormatHandler.getMediaFormat(mediaFormatNames[i]);
            if (mediaFormat != null) {
                String media = medias[i];
                MediaArgs.WidthOption[] widthOptions = ImageUtils.toWidthOptionArray(widths[i]);
                if (widthOptions.length <= 0) continue;
                MediaArgs.PictureSource pictureSource = new MediaArgs.PictureSource(mediaFormat);
                pictureSource.widthOptions(widthOptions);
                if (StringUtils.isNotBlank((CharSequence)media)) {
                    pictureSource.media(media);
                }
                builder.pictureSource(pictureSource);
                continue;
            }
            LOG.warn("Ignoring invalid media format: {}", (Object)mediaFormatNames[i]);
        }
    }

    public static long @NotNull [] toWidthsArray(@NotNull String widths) {
        if (StringUtils.isBlank((CharSequence)widths)) {
            return new long[0];
        }
        return Arrays.stream(StringUtils.split((String)widths, (String)",")).map(NumberUtils::toLong).filter(width -> width > 0L).sorted((l1, l2) -> Long.compare(l2, l1)).mapToLong(Long::longValue).toArray();
    }

    @NotNull
    public static @NotNull MediaArgs.WidthOption @NotNull [] toWidthOptionArray(@NotNull String widthOptions) {
        return Optional.ofNullable(WidthUtils.parseWidths(widthOptions)).orElse(new MediaArgs.WidthOption[0]);
    }
}

