/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.DropTarget;
import com.day.cq.wcm.api.components.InplaceEditingConfig;
import com.day.cq.wcm.commons.WCMUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.editcontext.DropTargetImpl;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.MediaInvalidReason;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.handler.media.impl.ipeconfig.CroppingRatios;
import io.wcm.handler.media.impl.ipeconfig.IPEConfigResourceProvider;
import io.wcm.handler.media.markup.MediaMarkupBuilderUtil;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.handler.mediasource.dam.impl.DamAsset;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaSupportService;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryService;
import io.wcm.sling.models.annotations.AemObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class DamMediaSource
extends MediaSource {
    @Self
    private Adaptable adaptable;
    @SlingObject
    private ResourceResolver resourceResolver;
    @SlingObject
    private Resource resource;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private WCMMode wcmMode;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private ComponentContext componentContext;
    @Self
    private MediaHandlerConfig mediaHandlerConfig;
    @Self
    private MediaFormatHandler mediaFormatHandler;
    @OSGiService
    private DynamicMediaSupportService dynamicMediaSupportService;
    @OSGiService
    private WebOptimizedImageDeliveryService webOptimizedImageDeliveryService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    public static final String ID = "dam";

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    public boolean accepts(@Nullable String mediaRef) {
        return StringUtils.startsWith((CharSequence)mediaRef, (CharSequence)"/content/dam/");
    }

    @Override
    @NotNull
    public String getPrimaryMediaRefProperty() {
        return this.mediaHandlerConfig.getMediaRefProperty();
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NotNull
    public Media resolveMedia(@NotNull Media media) {
        String mediaRef = this.getMediaRef(media.getMediaRequest(), this.mediaHandlerConfig);
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        boolean renditionsResolved = false;
        if (StringUtils.isNotBlank((CharSequence)mediaRef)) {
            if (media.getMediaRequest().getResource() != null) {
                this.updateMediaArgsFromResource(mediaArgs, media.getMediaRequest().getResource(), this.mediaHandlerConfig);
            }
            media.setCropDimension(this.getMediaCropDimension(media.getMediaRequest(), this.mediaHandlerConfig));
            media.setRotation(this.getMediaRotation(media.getMediaRequest(), this.mediaHandlerConfig));
            media.setMap(this.getMediaMap(media.getMediaRequest(), this.mediaHandlerConfig));
            Asset damAsset = null;
            Resource assetResource = this.resourceResolver.getResource(mediaRef);
            if (assetResource != null) {
                damAsset = (Asset)assetResource.adaptTo(Asset.class);
            }
            if (damAsset != null) {
                DamAsset asset = new DamAsset(media, damAsset, this.mediaHandlerConfig, this.dynamicMediaSupportService, this.webOptimizedImageDeliveryService, this.adaptable);
                media.setAsset(asset);
                renditionsResolved = this.resolveRenditions(media, asset, mediaArgs);
            }
        }
        if (!renditionsResolved) {
            if (media.getAsset() != null) {
                if (media.getRenditions().isEmpty()) {
                    media.setMediaInvalidReason(MediaInvalidReason.NO_MATCHING_RENDITION);
                } else {
                    media.setMediaInvalidReason(MediaInvalidReason.NOT_ENOUGH_MATCHING_RENDITIONS);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)mediaRef)) {
                media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_INVALID);
            } else {
                media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_MISSING);
            }
        }
        return media;
    }

    @Override
    public void enableMediaDrop(@NotNull HtmlElement element, @NotNull MediaRequest mediaRequest) {
        if (this.wcmMode == WCMMode.DISABLED || this.wcmMode == null) {
            return;
        }
        if (this.componentContext != null && this.componentContext.getEditContext() != null && MediaMarkupBuilderUtil.canApplyDragDropSupport(mediaRequest, this.componentContext)) {
            Optional<String> dropTargetCssClass;
            String refProperty = this.prependDotSlash(this.getMediaRefProperty(mediaRequest, this.mediaHandlerConfig));
            String cropProperty = this.prependDotSlash(this.getMediaCropProperty(mediaRequest, this.mediaHandlerConfig));
            String rotationProperty = this.prependDotSlash(this.getMediaRotationProperty(mediaRequest, this.mediaHandlerConfig));
            String mapProperty = this.prependDotSlash(this.getMediaMapProperty(mediaRequest, this.mediaHandlerConfig));
            String name = refProperty;
            if (StringUtils.contains((CharSequence)name, (CharSequence)"/")) {
                name = Text.getName((String)name);
            }
            if (!(dropTargetCssClass = this.getMediaDropTargetID()).isPresent()) {
                MediaRequest.MediaPropertyNames mediaPropertyNames = new MediaRequest.MediaPropertyNames().refProperty(refProperty).cropProperty(cropProperty).rotationProperty(rotationProperty).mapProperty(mapProperty);
                dropTargetCssClass = this.addMediaDroptarget(refProperty, mediaPropertyNames, name);
            }
            if (element != null) {
                element.addCssClass(dropTargetCssClass.get());
            }
        }
    }

    @Override
    public void setCustomIPECropRatios(@NotNull HtmlElement element, @NotNull MediaRequest mediaRequest) {
        CroppingRatios croppingRatios;
        Set<String> mediaFormatNames;
        if (this.wcmMode == WCMMode.DISABLED || this.wcmMode == null) {
            return;
        }
        if (this.componentContext != null && MediaMarkupBuilderUtil.canSetCustomIPECropRatios(mediaRequest, this.componentContext, this.mediaHandlerConfig.allowedIpeEditorTypes()) && !(mediaFormatNames = (croppingRatios = new CroppingRatios(this.mediaFormatHandler)).getMediaFormatsForCropping(mediaRequest)).isEmpty()) {
            String ipeConfigPath = IPEConfigResourceProvider.buildPath(this.componentContext.getResource().getPath(), mediaFormatNames);
            InplaceEditingConfig customIpeConfig = new InplaceEditingConfig(this.componentContext.getEditContext().getEditConfig().getInplaceEditingConfig());
            try {
                Field configPathField = InplaceEditingConfig.class.getDeclaredField("configPath");
                configPathField.setAccessible(true);
                configPathField.set(customIpeConfig, ipeConfigPath);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                this.log.warn("Unable to set custom IPE config via reflection for {}", (Object)this.componentContext.getResource().getPath(), (Object)ex);
            }
            this.componentContext.getEditContext().getEditConfig().setInplaceEditingConfig(customIpeConfig);
        }
    }

    private String prependDotSlash(String property) {
        if (!StringUtils.startsWith((CharSequence)property, (CharSequence)"./")) {
            return "./" + property;
        }
        return property;
    }

    private Optional<String> getMediaDropTargetID() {
        return this.componentContext.getEditContext().getEditConfig().getDropTargets().values().stream().filter(item -> ArrayUtils.contains((Object[])item.getGroups(), (Object)"media")).map(DropTarget::getId).findFirst();
    }

    private Optional<String> addMediaDroptarget(String refProperty, MediaRequest.MediaPropertyNames mediaPropertyNames, String name) {
        Component componentDefinition = WCMUtils.getComponent((Resource)this.resource);
        HashMap<String, String> params = new HashMap<String, String>();
        if (componentDefinition != null) {
            params.put("./sling:resourceType", componentDefinition.getPath());
            params.put(mediaPropertyNames.getCropProperty(), "");
            params.put(mediaPropertyNames.getRotationProperty(), "");
            params.put(mediaPropertyNames.getMapProperty(), "");
        }
        DropTargetImpl dropTarget = new DropTargetImpl(name, refProperty).setAccept((String[])MediaFileType.getImageContentTypes().stream().toArray(String[]::new)).setGroups(new String[]{"media"}).setParameters(params);
        this.componentContext.getEditContext().getEditConfig().getDropTargets().put(dropTarget.getId(), dropTarget);
        return Optional.of(dropTarget.getId());
    }

    public String toString() {
        return ID;
    }
}

