/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import io.wcm.handler.media.Asset;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.mediasource.dam.AssetRendition;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.DamRendition;
import io.wcm.handler.mediasource.dam.impl.DamUriTemplate;
import io.wcm.handler.mediasource.dam.impl.WebEnabledRenditionCropping;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaSupportService;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryService;
import io.wcm.wcm.commons.util.AemObjectReflectionToStringBuilder;
import io.wcm.wcm.commons.util.ToStringStyle;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DamAsset
extends SlingAdaptable
implements Asset {
    private final com.day.cq.dam.api.Asset asset;
    private final CropDimension cropDimension;
    private final Integer rotation;
    private final MediaArgs defaultMediaArgs;
    private final DamContext damContext;

    public DamAsset(Media media, com.day.cq.dam.api.Asset asset, MediaHandlerConfig mediaHandlerConfig, DynamicMediaSupportService dynamicMediaSupportService, WebOptimizedImageDeliveryService webOptimizedImageDeliveryService, Adaptable adaptable) {
        this.asset = asset;
        this.cropDimension = DamAsset.rescaleCropDimension(asset, media.getCropDimension());
        this.rotation = media.getRotation();
        this.defaultMediaArgs = media.getMediaRequest().getMediaArgs();
        this.damContext = new DamContext(asset, this.defaultMediaArgs, mediaHandlerConfig, dynamicMediaSupportService, webOptimizedImageDeliveryService, adaptable);
    }

    @Nullable
    private static CropDimension rescaleCropDimension(@NotNull com.day.cq.dam.api.Asset asset, @Nullable CropDimension cropDimension) {
        if (cropDimension == null) {
            return null;
        }
        return WebEnabledRenditionCropping.getCropDimensionForOriginal(asset, cropDimension);
    }

    @Override
    public String getTitle() {
        String title = this.getPropertyAwareOfArray("dc:title");
        return StringUtils.defaultString((String)title, (String)this.damContext.getAsset().getName());
    }

    @Nullable
    private String getPropertyAwareOfArray(@NotNull String propertyName) {
        String valueObject = this.asset.getMetadataValueFromJcr(propertyName);
        String value = null;
        if (valueObject != null) {
            if (valueObject instanceof Object[]) {
                Object[] valueArray = (Object[])valueObject;
                if (valueArray.length > 0) {
                    value = valueArray[0].toString();
                }
            } else {
                value = valueObject.toString();
            }
        }
        return (String)StringUtils.defaultIfBlank(value, null);
    }

    @Override
    public String getAltText() {
        if (this.defaultMediaArgs.isDecorative()) {
            return "";
        }
        if (!this.defaultMediaArgs.isForceAltValueFromAsset() && StringUtils.isNotEmpty((CharSequence)this.defaultMediaArgs.getAltText())) {
            return this.defaultMediaArgs.getAltText();
        }
        return StringUtils.defaultString((String)this.getDescription(), (String)this.getTitle());
    }

    @Override
    public String getDescription() {
        return this.getPropertyAwareOfArray("dc:description");
    }

    @Override
    @NotNull
    public String getPath() {
        return this.damContext.getAsset().getPath();
    }

    @Override
    @NotNull
    public ValueMap getProperties() {
        return new ValueMapDecorator(this.asset.getMetadata());
    }

    @Override
    public Rendition getDefaultRendition() {
        return this.getRendition(this.defaultMediaArgs);
    }

    @Override
    public Rendition getRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getDamRendition(mediaArgs);
        if (StringUtils.isEmpty((CharSequence)rendition.getUrl())) {
            rendition = null;
        }
        return rendition;
    }

    @Override
    public Rendition getImageRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isImage()) {
            return rendition;
        }
        return null;
    }

    @Override
    public Rendition getDownloadRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isDownload()) {
            return rendition;
        }
        return null;
    }

    protected Rendition getDamRendition(MediaArgs mediaArgs) {
        return new DamRendition(this.cropDimension, this.rotation, mediaArgs, this.damContext);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == com.day.cq.dam.api.Asset.class) {
            return (AdapterType)this.damContext.getAsset();
        }
        if (type == Resource.class) {
            return (AdapterType)this.damContext.getAsset().adaptTo(Resource.class);
        }
        return (AdapterType)super.adaptTo(type);
    }

    @Override
    @NotNull
    public UriTemplate getUriTemplate(@NotNull UriTemplateType type) {
        String extension = FilenameUtils.getExtension((String)this.damContext.getAsset().getName());
        if (!MediaFileType.isImage(extension) || MediaFileType.isVectorImage(extension)) {
            throw new UnsupportedOperationException("Unable to build URI template for this asset type: " + this.getPath());
        }
        com.day.cq.dam.api.Rendition original = this.damContext.getAsset().getOriginal();
        Dimension dimension = AssetRendition.getDimension(original);
        if (dimension == null) {
            throw new IllegalArgumentException("Unable to get dimension for original rendition of asset: " + this.getPath());
        }
        return new DamUriTemplate(type, dimension, original, null, null, null, this.damContext);
    }

    public String toString() {
        return new AemObjectReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE).build();
    }
}

