/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.format.impl.MediaFormatSupport;
import io.wcm.handler.media.format.impl.MediaFormatVisitor;
import io.wcm.handler.mediasource.dam.AemRenditionType;
import io.wcm.handler.mediasource.dam.AssetRendition;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.RenditionHandler;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.VirtualRenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.VirtualTransformedRenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.SmartCrop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRenditionHandler
implements RenditionHandler {
    private Set<RenditionMetadata> renditions;
    private final RenditionMetadata originalRendition;
    private final DamContext damContext;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    DefaultRenditionHandler(DamContext damContext) {
        this.damContext = damContext;
        Rendition damOriginalRendition = damContext.getAsset().getOriginal();
        this.originalRendition = damOriginalRendition != null ? new RenditionMetadata(damOriginalRendition) : null;
    }

    protected RenditionMetadata getOriginalRendition() {
        return this.originalRendition;
    }

    Set<RenditionMetadata> getAvailableRenditions(MediaArgs mediaArgs) {
        if (this.renditions == null) {
            Set<RenditionMetadata> candidates = new TreeSet<RenditionMetadata>();
            for (Rendition rendition : this.damContext.getAsset().getRenditions()) {
                this.addRendition(candidates, rendition, mediaArgs);
            }
            if (this.damContext.isDynamicMediaEnabled() && this.damContext.isDynamicMediaAsset()) {
                List<CropDimension> cropDimensions;
                String fileExtension = FilenameUtils.getExtension((String)this.damContext.getAsset().getName());
                if (this.damContext.isDynamicMediaValidateSmartCropRenditionSizes() && MediaFileType.isImage(fileExtension) && !MediaFileType.isVectorImage(fileExtension) && !(cropDimensions = this.getDynamicMediaCropDimensions(mediaArgs)).isEmpty()) {
                    candidates.addAll(cropDimensions.stream().map(cropDimension -> new VirtualTransformedRenditionMetadata(this.originalRendition.getRendition(), cropDimension.getWidth(), cropDimension.getHeight(), mediaArgs.getEnforceOutputFileExtension(), (CropDimension)cropDimension, null, mediaArgs.getImageQualityPercentage())).collect(Collectors.toList()));
                }
            }
            candidates = this.postProcessCandidates(candidates, mediaArgs);
            this.renditions = Collections.unmodifiableSet(candidates);
        }
        return this.renditions;
    }

    protected Set<RenditionMetadata> postProcessCandidates(Set<RenditionMetadata> candidates, MediaArgs mediaArgs) {
        return candidates;
    }

    private void addRendition(Set<RenditionMetadata> candidates, Rendition rendition, MediaArgs mediaArgs) {
        AemRenditionType aemRenditionType = AemRenditionType.forRendition(rendition);
        if (aemRenditionType != null && !this.getIncludeAssetAemRenditions(mediaArgs).contains((Object)aemRenditionType)) {
            return;
        }
        if (!AssetRendition.isOriginal(rendition) && (this.damContext.isDynamicMediaEnabled() && this.damContext.isDynamicMediaAsset() || this.damContext.isWebOptimizedImageDeliveryEnabled())) {
            return;
        }
        RenditionMetadata renditionMetadata = this.createRenditionMetadata(rendition);
        candidates.add(renditionMetadata);
    }

    @NotNull
    private Set<AemRenditionType> getIncludeAssetAemRenditions(MediaArgs mediaArgs) {
        Boolean includeAssetThumbnails;
        Set<AemRenditionType> fromMediaArgs = mediaArgs.getIncludeAssetAemRenditions();
        if (fromMediaArgs == null) {
            fromMediaArgs = Set.of();
        }
        HashSet<AemRenditionType> result = new HashSet<AemRenditionType>(fromMediaArgs);
        Boolean includeAssetWebRenditions = mediaArgs.isIncludeAssetWebRenditions();
        if (includeAssetWebRenditions != null) {
            if (includeAssetWebRenditions.booleanValue()) {
                result.add(AemRenditionType.WEB_RENDITION);
            } else {
                result.remove((Object)AemRenditionType.WEB_RENDITION);
            }
        }
        if ((includeAssetThumbnails = mediaArgs.isIncludeAssetThumbnails()) != null) {
            if (includeAssetThumbnails.booleanValue()) {
                result.add(AemRenditionType.THUMBNAIL_RENDITION);
            } else {
                result.remove((Object)AemRenditionType.THUMBNAIL_RENDITION);
            }
        }
        return result;
    }

    @NotNull
    private List<CropDimension> getDynamicMediaCropDimensions(MediaArgs mediaArgs) {
        MediaArgs.MediaFormatOption[] mediaFormatOptions = mediaArgs.getMediaFormatOptions();
        if (mediaFormatOptions == null) {
            return Collections.emptyList();
        }
        ArrayList<CropDimension> result = new ArrayList<CropDimension>();
        for (MediaArgs.MediaFormatOption mediaFormatOption : mediaFormatOptions) {
            CropDimension cropDimension;
            NamedDimension smartCropDef;
            MediaFormat mediaFormat = mediaFormatOption.getMediaFormat();
            if (mediaFormat == null || !mediaFormat.hasRatio() || (smartCropDef = SmartCrop.getDimensionForRatio(this.damContext.getImageProfile(), mediaFormat.getRatio())) == null || (cropDimension = SmartCrop.getCropDimensionForAsset(this.damContext.getAsset(), this.damContext.getResourceResolver(), smartCropDef)) == null) continue;
            result.add(cropDimension);
        }
        return result;
    }

    protected RenditionMetadata createRenditionMetadata(Rendition rendition) {
        return new RenditionMetadata(rendition);
    }

    private Set<RenditionMetadata> getRendtionsMatchingFileExtensions(String[] fileExtensions, MediaArgs mediaArgs) {
        Set<RenditionMetadata> allRenditions = this.getAvailableRenditions(mediaArgs);
        if (fileExtensions == null || fileExtensions.length == 0) {
            return allRenditions;
        }
        TreeSet<RenditionMetadata> matchingRenditions = new TreeSet<RenditionMetadata>();
        block0: for (RenditionMetadata rendition : allRenditions) {
            for (String fileExtension : fileExtensions) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)fileExtension, (CharSequence)rendition.getFileExtension())) continue;
                matchingRenditions.add(rendition);
                continue block0;
            }
        }
        return matchingRenditions;
    }

    @Override
    public RenditionMetadata getRendition(MediaArgs mediaArgs) {
        Object[] requestedFileExtensions = MediaFormatSupport.getRequestedFileExtensions(mediaArgs);
        if (requestedFileExtensions == null) {
            return null;
        }
        boolean isSizeMatchingRequest = this.isSizeMatchingRequest(mediaArgs, (String[])requestedFileExtensions);
        Set<RenditionMetadata> candidates = this.getRendtionsMatchingFileExtensions((String[])requestedFileExtensions, mediaArgs);
        if (this.log.isTraceEnabled()) {
            this.log.trace("GetRendition: requestedFileExtensions={}, isSizeMatchingRequest={}, mediaArgs={}, candidates={}", new Object[]{StringUtils.join((Object[])requestedFileExtensions, (String)","), isSizeMatchingRequest, mediaArgs, candidates});
        }
        if (!isSizeMatchingRequest) {
            return this.getOriginalOrFirstRendition(candidates);
        }
        RenditionMetadata exactMatchRendition = this.getExactMatchRendition(candidates, mediaArgs);
        if (exactMatchRendition != null && !this.enforceVirtualRendition(exactMatchRendition, mediaArgs)) {
            return exactMatchRendition;
        }
        RenditionMetadata virtualRendition = this.getVirtualRendition(candidates, mediaArgs);
        if (virtualRendition != null) {
            return virtualRendition;
        }
        return null;
    }

    protected boolean enforceVirtualRendition(RenditionMetadata rendition, MediaArgs mediaArgs) {
        if (rendition.isImage() && !rendition.isVectorImage()) {
            if (this.damContext.getMediaHandlerConfig().enforceVirtualRenditions()) {
                return true;
            }
            if (mediaArgs.getEnforceOutputFileExtension() != null) {
                return !StringUtils.equalsIgnoreCase((CharSequence)rendition.getFileExtension(), (CharSequence)mediaArgs.getEnforceOutputFileExtension());
            }
        }
        return false;
    }

    private boolean isSizeMatchingRequest(final MediaArgs mediaArgs, String[] requestedFileExtensions) {
        boolean anyImageFileExtension = false;
        for (String fileExtension : requestedFileExtensions) {
            if (!MediaFileType.isImage(fileExtension)) continue;
            anyImageFileExtension = true;
            break;
        }
        if (!anyImageFileExtension && mediaArgs.getFixedWidth() == 0L && mediaArgs.getFixedHeight() == 0L) {
            return false;
        }
        if (mediaArgs.getFixedWidth() > 0L || mediaArgs.getFixedHeight() > 0L) {
            return true;
        }
        Boolean isSizeMatchingMediaFormat = MediaFormatSupport.visitMediaFormats(mediaArgs, new MediaFormatVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visit(@NotNull MediaFormat mediaFormat) {
                if (mediaFormat.getEffectiveMinWidth() > 0L || mediaFormat.getEffectiveMaxWidth() > 0L || mediaFormat.getEffectiveMinHeight() > 0L || mediaFormat.getEffectiveMaxHeight() > 0L || mediaFormat.getMinWidthHeight() > 0L || mediaFormat.getRatio() > 0.0) {
                    return true;
                }
                if (mediaArgs.getImageSizes() != null || mediaArgs.getPictureSources() != null) {
                    return true;
                }
                return null;
            }
        });
        return isSizeMatchingMediaFormat != null && isSizeMatchingMediaFormat != false;
    }

    private RenditionMetadata getExactMatchRendition(final Set<RenditionMetadata> candidates, MediaArgs mediaArgs) {
        MediaFormat[] mediaFormats = mediaArgs.getMediaFormats();
        if (mediaArgs.getFixedWidth() > 0L || mediaArgs.getFixedHeight() > 0L) {
            for (RenditionMetadata candidate : candidates) {
                if (!candidate.matches(mediaArgs.getFixedWidth(), mediaArgs.getFixedHeight())) continue;
                return candidate;
            }
        } else {
            if (mediaFormats != null && mediaFormats.length > 0) {
                return MediaFormatSupport.visitMediaFormats(mediaArgs, new MediaFormatVisitor<RenditionMetadata>(){

                    @Override
                    @Nullable
                    public RenditionMetadata visit(@NotNull MediaFormat mediaFormat) {
                        for (RenditionMetadata candidate : candidates) {
                            if (!candidate.matches(mediaFormat.getEffectiveMinWidth(), mediaFormat.getEffectiveMinHeight(), mediaFormat.getEffectiveMaxWidth(), mediaFormat.getEffectiveMaxHeight(), mediaFormat.getMinWidthHeight(), mediaFormat.getRatio())) continue;
                            candidate.setMediaFormat(mediaFormat);
                            return candidate;
                        }
                        return null;
                    }
                });
            }
            return this.getOriginalOrFirstRendition(candidates);
        }
        return null;
    }

    private RenditionMetadata getOriginalOrFirstRendition(Set<RenditionMetadata> candidates) {
        if (this.originalRendition != null && candidates.contains(this.originalRendition)) {
            return this.originalRendition;
        }
        if (!candidates.isEmpty()) {
            return candidates.iterator().next();
        }
        return null;
    }

    private RenditionMetadata getVirtualRendition(final Set<RenditionMetadata> candidates, final MediaArgs mediaArgs) {
        if (mediaArgs.getFixedWidth() > 0L || mediaArgs.getFixedHeight() > 0L) {
            long destWidth = mediaArgs.getFixedWidth();
            long destHeight = mediaArgs.getFixedHeight();
            double destRatio = 0.0;
            if (destWidth > 0L && destHeight > 0L) {
                destRatio = Ratio.get(destWidth, destHeight);
            }
            return this.getVirtualRendition(candidates, destWidth, destHeight, 0L, destRatio, mediaArgs.getEnforceOutputFileExtension(), mediaArgs.getImageQualityPercentage());
        }
        return MediaFormatSupport.visitMediaFormats(mediaArgs, new MediaFormatVisitor<RenditionMetadata>(){

            @Override
            @Nullable
            public RenditionMetadata visit(@NotNull MediaFormat mediaFormat) {
                double destRatio;
                long minWidthHeight;
                long destHeight;
                long destWidth = mediaFormat.getEffectiveMinWidth();
                RenditionMetadata rendition = DefaultRenditionHandler.this.getVirtualRendition(candidates, destWidth, destHeight = mediaFormat.getEffectiveMinHeight(), minWidthHeight = mediaFormat.getMinWidthHeight(), destRatio = mediaFormat.getRatio(), mediaArgs.getEnforceOutputFileExtension(), mediaArgs.getImageQualityPercentage());
                if (rendition != null) {
                    rendition.setMediaFormat(mediaFormat);
                }
                return rendition;
            }
        });
    }

    private RenditionMetadata getVirtualRendition(@NotNull Set<RenditionMetadata> candidates, long destWidth, long destHeight, long minWidthHeight, double destRatio, @Nullable String enforceOutputFileExtension, @Nullable Double imageQualityPercentage) {
        if (destRatio > 0.0) {
            for (RenditionMetadata candidate : candidates) {
                if (!candidate.matches(destWidth, destHeight, 0L, 0L, minWidthHeight, destRatio)) continue;
                return this.getVirtualRendition(candidate, destWidth, destHeight, destRatio, enforceOutputFileExtension, imageQualityPercentage);
            }
        } else {
            for (RenditionMetadata candidate : candidates) {
                if (!candidate.matches(destWidth, destHeight, 0L, 0L, minWidthHeight, 0.0)) continue;
                return this.getVirtualRendition(candidate, destWidth, destHeight, 0.0, enforceOutputFileExtension, imageQualityPercentage);
            }
        }
        return null;
    }

    private RenditionMetadata getVirtualRendition(@NotNull RenditionMetadata rendition, long widthValue, long heightValue, double ratioValue, @Nullable String enforceOutputFileExtension, @Nullable Double imageQualityPercentage) {
        long width = widthValue;
        long height = heightValue;
        double ratio = ratioValue;
        if (ratio < 0.05) {
            ratio = Ratio.get(rendition.getWidth(), rendition.getHeight());
        }
        if (height == 0L && width > 0L) {
            height = Math.round((double)width / ratio);
        }
        if (width == 0L && height > 0L) {
            width = Math.round((double)height * ratio);
        }
        if (width > 0L && height > 0L) {
            if (rendition instanceof VirtualTransformedRenditionMetadata) {
                VirtualTransformedRenditionMetadata cropRendition = (VirtualTransformedRenditionMetadata)rendition;
                return new VirtualTransformedRenditionMetadata(cropRendition.getRendition(), width, height, enforceOutputFileExtension, cropRendition.getCropDimension(), cropRendition.getRotation(), imageQualityPercentage);
            }
            return new VirtualRenditionMetadata(rendition.getRendition(), width, height, enforceOutputFileExtension, imageQualityPercentage);
        }
        return null;
    }

    protected Asset getAsset() {
        return this.damContext.getAsset();
    }
}

