/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.DefaultRenditionHandler;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.VirtualTransformedRenditionMetadata;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TransformedRenditionHandler
extends DefaultRenditionHandler {
    private final CropDimension cropDimension;
    private final Integer rotation;

    TransformedRenditionHandler(CropDimension cropDimension, Integer rotation, DamContext damContext) {
        super(damContext);
        this.cropDimension = cropDimension;
        this.rotation = rotation != null && ImageTransformation.isValidRotation(rotation) ? rotation : null;
    }

    @Override
    protected Set<RenditionMetadata> postProcessCandidates(Set<RenditionMetadata> candidates, MediaArgs mediaArgs) {
        VirtualTransformedRenditionMetadata cropRendition;
        TreeSet<RenditionMetadata> processedCandidates = new TreeSet<RenditionMetadata>(candidates);
        if (this.cropDimension != null && (cropRendition = this.getCropRendition(mediaArgs)) != null) {
            processedCandidates.clear();
            processedCandidates.add(cropRendition);
            return processedCandidates;
        }
        return this.rotateSourceRenditions(processedCandidates, mediaArgs);
    }

    private NavigableSet<RenditionMetadata> rotateSourceRenditions(Set<RenditionMetadata> candidates, MediaArgs mediaArgs) {
        if (this.rotation == null) {
            return new TreeSet<RenditionMetadata>(candidates);
        }
        return candidates.stream().filter(rendition -> !rendition.isVectorImage()).map(rendition -> new VirtualTransformedRenditionMetadata(rendition.getRendition(), ImageTransformation.rotateMapWidth(rendition.getWidth(), rendition.getHeight(), this.rotation), ImageTransformation.rotateMapHeight(rendition.getWidth(), rendition.getHeight(), this.rotation), mediaArgs.getEnforceOutputFileExtension(), null, this.rotation, mediaArgs.getImageQualityPercentage())).collect(Collectors.toCollection(TreeSet::new));
    }

    private VirtualTransformedRenditionMetadata getCropRendition(MediaArgs mediaArgs) {
        RenditionMetadata original = this.getOriginalRendition();
        if (original == null || original.isVectorImage()) {
            return null;
        }
        return new VirtualTransformedRenditionMetadata(original.getRendition(), ImageTransformation.rotateMapWidth(this.cropDimension.getWidth(), this.cropDimension.getHeight(), this.rotation), ImageTransformation.rotateMapHeight(this.cropDimension.getWidth(), this.cropDimension.getHeight(), this.rotation), mediaArgs.getEnforceOutputFileExtension(), this.cropDimension, this.rotation, mediaArgs.getImageQualityPercentage());
    }

    @Override
    protected boolean enforceVirtualRendition(RenditionMetadata rendition, MediaArgs mediaArgs) {
        return false;
    }
}

