/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Rendition;
import com.day.image.Layer;
import io.wcm.handler.media.impl.ImageFileServlet;
import io.wcm.handler.media.impl.ImageFileServletSelector;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaPath;
import io.wcm.handler.mediasource.dam.impl.weboptimized.WebOptimizedImageDeliveryParams;
import java.io.InputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualRenditionMetadata
extends RenditionMetadata {
    private final long width;
    private final long height;
    private final String enforceOutputFileExtension;
    private final Double imageQualityPercentage;

    VirtualRenditionMetadata(@NotNull Rendition rendition, long width, long height, @Nullable String enforceOutputFileExtension, @Nullable Double imageQualityPercentage) {
        super(rendition);
        this.width = width;
        this.height = height;
        this.enforceOutputFileExtension = enforceOutputFileExtension;
        this.imageQualityPercentage = imageQualityPercentage;
    }

    @Override
    public String getFileName(boolean contentDispositionAttachment) {
        if (this.isVectorImage()) {
            return super.getFileName(contentDispositionAttachment);
        }
        return ImageFileServlet.getImageFileName(super.getFileName(contentDispositionAttachment), this.enforceOutputFileExtension);
    }

    @Override
    public long getFileSize() {
        return 0L;
    }

    @Override
    public long getWidth() {
        return this.width;
    }

    @Override
    public long getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public String getMediaPath(boolean contentDispositionAttachment) {
        if (this.isVectorImage()) {
            return super.getMediaPath(contentDispositionAttachment);
        }
        return VirtualRenditionMetadata.buildMediaPath(this.getRendition().getPath() + "." + ImageFileServletSelector.build(this.getWidth(), this.getHeight(), null, null, this.imageQualityPercentage, contentDispositionAttachment) + ".file", this.getFileName(contentDispositionAttachment));
    }

    @Override
    @Nullable
    public String getDynamicMediaPath(boolean contentDispositionAttachment, DamContext damContext) {
        if (contentDispositionAttachment) {
            return DynamicMediaPath.buildContent(damContext, true);
        }
        if (this.isVectorImage()) {
            return DynamicMediaPath.buildContent(damContext, false);
        }
        return DynamicMediaPath.buildImage(damContext, this.getWidth(), this.getHeight());
    }

    @Override
    @Nullable
    public String getWebOptimizedImageDeliveryPath(DamContext damContext) {
        return damContext.getWebOptimizedImageDeliveryUrl(new WebOptimizedImageDeliveryParams().width(this.getWidth()));
    }

    @Override
    protected Layer getLayer() {
        Layer layer = super.getLayer();
        if (layer != null) {
            layer.resize((int)this.getWidth(), (int)this.getHeight());
        }
        return layer;
    }

    @Override
    protected InputStream getInputStream() {
        return null;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getRendition().getPath()).append(this.width).append(this.height).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VirtualRenditionMetadata other = (VirtualRenditionMetadata)obj;
        return new EqualsBuilder().append((Object)this.getRendition().getPath(), (Object)other.getRendition().getPath()).append(this.width, other.width).append(this.height, other.height).build();
    }

    @Override
    public String toString() {
        return super.toString() + " -> " + this.width + "x" + this.height;
    }
}

