/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Asset;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.mediasource.dam.AssetRendition;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WebEnabledRenditionCropping {
    private WebEnabledRenditionCropping() {
    }

    @NotNull
    public static CropDimension getCropDimensionForOriginal(@NotNull Asset asset, @NotNull CropDimension cropDimensionForWebRendition) {
        long scaledHeight;
        RenditionMetadata original = new RenditionMetadata(asset.getOriginal());
        Double scaleFactor = WebEnabledRenditionCropping.getCropScaleFactor(asset, original);
        long scaledLeft = Math.round((double)cropDimensionForWebRendition.getLeft() * scaleFactor);
        long scaledTop = Math.round((double)cropDimensionForWebRendition.getTop() * scaleFactor);
        long scaledWidth = Math.round((double)cropDimensionForWebRendition.getWidth() * scaleFactor);
        if (scaledWidth > original.getWidth()) {
            scaledWidth = original.getWidth();
        }
        if ((scaledHeight = Math.round((double)cropDimensionForWebRendition.getHeight() * scaleFactor)) > original.getHeight()) {
            scaledHeight = original.getHeight();
        }
        return new CropDimension(scaledLeft, scaledTop, scaledWidth, scaledHeight, cropDimensionForWebRendition.isAutoCrop());
    }

    private static double getCropScaleFactor(@NotNull Asset asset, @NotNull RenditionMetadata original) {
        RenditionMetadata webEnabled = WebEnabledRenditionCropping.getWebEnabledRendition(asset);
        if (webEnabled == null || original.getWidth() == 0L || webEnabled.getWidth() == 0L) {
            return 1.0;
        }
        return Ratio.get(original.getWidth(), webEnabled.getWidth());
    }

    @Nullable
    private static RenditionMetadata getWebEnabledRendition(@NotNull Asset asset) {
        return asset.getRenditions().stream().filter(AssetRendition::isWebRendition).findFirst().map(RenditionMetadata::new).orElse(null);
    }
}

