/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.dynamicmedia;

import com.day.cq.dam.api.Asset;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.mediasource.dam.AssetRendition;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfile;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import java.util.Arrays;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartCrop {
    public static final String PN_NORMALIZED_WIDTH = "normalizedWidth";
    public static final String PN_NORMALIZED_HEIGHT = "normalizedHeight";
    public static final String PN_LEFT = "left";
    public static final String PN_TOP = "top";
    private static final double MIN_NORMALIZED_WIDTH_HEIGHT = 1.0E-4;
    private static final Logger log = LoggerFactory.getLogger(SmartCrop.class);

    private SmartCrop() {
    }

    public static boolean canApply(@Nullable CropDimension cropDimension, @Nullable Integer rotation) {
        return (cropDimension == null || cropDimension.isAutoCrop()) && rotation == null;
    }

    @Nullable
    public static NamedDimension getDimensionForRatio(@Nullable ImageProfile imageProfile, double requestedRatio) {
        if (imageProfile == null) {
            return null;
        }
        return imageProfile.getSmartCropDefinitions().stream().filter(def -> Ratio.matches(Ratio.get(def), requestedRatio)).findFirst().orElse(null);
    }

    @Nullable
    public static NamedDimension getDimensionForWidthHeight(@Nullable ImageProfile imageProfile, long width, long height) {
        Double requestedRatio = Ratio.get(width, height);
        NamedDimension matchingDimension = SmartCrop.getDimensionForRatio(imageProfile, requestedRatio);
        if (matchingDimension != null) {
            return new NamedDimension(matchingDimension.getName(), width, height);
        }
        return null;
    }

    @Nullable
    public static CropDimension getCropDimensionForAsset(@NotNull Asset asset, @NotNull ResourceResolver resourceResolver, @NotNull NamedDimension smartCropDef) {
        double actualRatio;
        String smartCropRenditionPath = asset.getPath() + "/jcr:content/renditions/" + smartCropDef.getName() + "/jcr:content";
        Resource smartCropRendition = resourceResolver.getResource(smartCropRenditionPath);
        if (smartCropRendition == null) {
            return null;
        }
        ValueMap props = smartCropRendition.getValueMap();
        double leftPercentage = (Double)props.get(PN_LEFT, (Object)0.0);
        double topPercentage = (Double)props.get(PN_TOP, (Object)0.0);
        double widthPercentage = (Double)props.get(PN_NORMALIZED_WIDTH, (Object)0.0);
        double heightPercentage = (Double)props.get(PN_NORMALIZED_HEIGHT, (Object)0.0);
        Dimension originalDimension = AssetRendition.getDimension(asset.getOriginal());
        if (originalDimension == null || !SmartCrop.isValidTopLeft(leftPercentage, topPercentage) || !SmartCrop.isValidWidthHeight(widthPercentage, heightPercentage)) {
            return null;
        }
        long originalWidth = originalDimension.getWidth();
        long originalHeight = originalDimension.getHeight();
        long left = Math.round((double)originalWidth * leftPercentage);
        long top = Math.round((double)originalHeight * topPercentage);
        long width = Math.round((double)originalWidth * widthPercentage);
        long height = Math.round((double)originalHeight * heightPercentage);
        double expectedRatio = Ratio.get(smartCropDef.getWidth(), smartCropDef.getHeight());
        if (!Ratio.matches(expectedRatio, actualRatio = Ratio.get(width, height))) {
            if (actualRatio > expectedRatio) {
                width = Math.round((double)height * expectedRatio);
            } else {
                height = Math.round((double)width / expectedRatio);
            }
        }
        return new CropDimension(left, top, width, height, true);
    }

    public static boolean isMatchingSize(@NotNull Asset asset, @NotNull ResourceResolver resourceResolver, @NotNull NamedDimension smartCropDef, long width, long height) {
        boolean isMatchingSize;
        CropDimension cropDimension = SmartCrop.getCropDimensionForAsset(asset, resourceResolver, smartCropDef);
        if (cropDimension == null) {
            return true;
        }
        long croppedWidth = cropDimension.getWidth();
        long croppedHeight = cropDimension.getHeight();
        boolean bl = isMatchingSize = cropDimension.getWidth() >= width && croppedHeight >= height;
        if (!isMatchingSize) {
            log.debug("Smart cropping area '{}' for asset {} is too small ({} x {}) for requested size {} x {}.", new Object[]{smartCropDef.getName(), asset.getPath(), croppedWidth, croppedHeight, width, height});
        }
        return isMatchingSize;
    }

    private static boolean isValidTopLeft(double ... numbers) {
        return Arrays.stream(numbers).allMatch(value -> value >= 0.0 && value <= 1.0);
    }

    private static boolean isValidWidthHeight(double ... numbers) {
        return Arrays.stream(numbers).allMatch(value -> value >= 1.0E-4 && value <= 1.0);
    }
}

