/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.metadata;

import com.adobe.granite.workflow.collection.ResourceCollection;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkflowProcessUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkflowProcessUtil.class);
    static final String RT_WORKFLOW_PACKAGE = "cq/workflow/components/collection/page";

    private WorkflowProcessUtil() {
    }

    @Nullable
    public static String getPayloadResourcePath(@NotNull WorkItem workItem) {
        WorkflowData data = workItem.getWorkflowData();
        if (StringUtils.equals((CharSequence)data.getPayloadType(), (CharSequence)"JCR_PATH")) {
            return data.getPayload().toString();
        }
        return null;
    }

    @NotNull
    public static List<String> getPayloadResourcePaths(@NotNull String payloadPath, @NotNull String primaryTypeResourceType, @NotNull ResourceResolver resourceResolver, @NotNull ResourceCollectionManager resourceCollectionManager) {
        Session session = (Session)AdaptTo.notNull((Adaptable)resourceResolver, Session.class);
        ArrayList<String> assetPaths = new ArrayList<String>();
        try {
            if (session.nodeExists(payloadPath)) {
                Node node = session.getNode(payloadPath);
                if (WorkflowProcessUtil.isWorkflowPackagePage(node, resourceResolver)) {
                    List resourceCollections = resourceCollectionManager.getCollectionsForNode(node);
                    for (ResourceCollection resourceCollection : resourceCollections) {
                        for (Node memberNode : resourceCollection.list(new String[]{primaryTypeResourceType})) {
                            assetPaths.add(memberNode.getPath());
                        }
                    }
                } else {
                    assetPaths.add(payloadPath);
                }
            }
        }
        catch (RepositoryException ex) {
            log.warn("Unable to resolve resource paths from workflow payload: {}", (Object)payloadPath, (Object)ex);
        }
        return assetPaths;
    }

    private static boolean isWorkflowPackagePage(Node node, ResourceResolver resourceResolver) throws RepositoryException {
        Resource resource;
        if (node.isNodeType("cq:Page") && (resource = resourceResolver.getResource(node.getPath() + "/jcr:content")) != null) {
            return resource.isResourceType(RT_WORKFLOW_PACKAGE);
        }
        return false;
    }
}

