/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.metadata.concurrency;

final class StripeIndex {
    private final int mask;
    private final int size;
    private static final int ALL_SET = -1;
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    StripeIndex(int stripes) {
        if (stripes <= 0) {
            throw new IllegalArgumentException("Invalid number of stripes: " + stripes);
        }
        this.mask = stripes > 0x40000000 ? -1 : StripeIndex.ceilToPowerOfTwo(stripes) - 1;
        this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
    }

    int size() {
        return this.size;
    }

    int indexFor(Object key) {
        int hash = StripeIndex.smear(key.hashCode());
        return hash & this.mask;
    }

    private static int smear(int hashCode) {
        int newHashCode = hashCode;
        newHashCode ^= newHashCode >>> 20 ^ newHashCode >>> 12;
        return newHashCode ^ newHashCode >>> 7 ^ newHashCode >>> 4;
    }

    private static int ceilToPowerOfTwo(int x) {
        return 1 << StripeIndex.log2RoundCeiling(x);
    }

    private static int log2RoundCeiling(int x) {
        return 32 - Integer.numberOfLeadingZeros(x - 1);
    }
}

