/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.weboptimized;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

final class RelativeCroppingString {
    private static final NumberFormat DECIMAL_FORMAT = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));

    private RelativeCroppingString() {
    }

    @NotNull
    static String createFromCropDimension(@NotNull CropDimension cropDimension, @NotNull Dimension imageDimension) {
        double x1 = cropDimension.getLeft();
        double y1 = cropDimension.getTop();
        double left = x1 / (double)imageDimension.getWidth();
        double top = y1 / (double)imageDimension.getHeight();
        double width = (double)cropDimension.getWidth() / (double)imageDimension.getWidth();
        double height = (double)cropDimension.getHeight() / (double)imageDimension.getHeight();
        return RelativeCroppingString.create(left, top, width, height);
    }

    @NotNull
    static String create(double left, double top, double width, double height) {
        return String.format("%sp,%sp,%sp,%sp", RelativeCroppingString.toPercentage(left), RelativeCroppingString.toPercentage(top), RelativeCroppingString.toPercentage(width), RelativeCroppingString.toPercentage(height));
    }

    private static String toPercentage(double fraction) {
        double percentage = (double)Math.round(fraction * 1000.0) / 10.0;
        percentage = Math.max(0.0, percentage);
        percentage = Math.min(100.0, percentage);
        return DECIMAL_FORMAT.format(percentage);
    }
}

