/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.markup;

import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import com.day.cq.dam.video.VideoProfile;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Video;
import io.wcm.handler.media.Asset;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.markup.MediaMarkupBuilderUtil;
import io.wcm.handler.media.spi.MediaMarkupBuilder;
import io.wcm.handler.url.UrlHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ConsumerType
public class DamVideoMediaMarkupBuilder
implements MediaMarkupBuilder {
    private static final String H264_PROFILE = "format_aac";
    private static final String OGG_PROFILE = "format_ogg";
    private static final String LEGACY_H264_PROFILE = "hq";
    private static final String LEGACY_OGG_PROFILE = "firefoxhq";
    private static final List<String> VIDEO_PROFILE_NAMES = List.of("format_aac", "format_ogg", "hq", "firefoxhq");
    private static final Logger log = LoggerFactory.getLogger(DamVideoMediaMarkupBuilder.class);
    @SlingObject
    private ResourceResolver resourceResolver;
    @Self
    private UrlHandler urlHandler;
    @OSGiService
    private ConfigurationResourceResolver configurationResourceResolver;

    @Override
    public final boolean accepts(@NotNull Media media) {
        if (!media.isValid()) {
            return false;
        }
        com.day.cq.dam.api.Asset asset = this.getDamAsset(media);
        if (asset != null) {
            return asset.getRendition((RenditionPicker)new PrefixRenditionPicker("cq5dam.video.")) != null;
        }
        return false;
    }

    protected List<String> getVideoProfileNames() {
        return VIDEO_PROFILE_NAMES;
    }

    protected List<VideoProfile> getVideoProfiles() {
        ArrayList<VideoProfile> profiles = new ArrayList<VideoProfile>();
        for (String profileName : this.getVideoProfileNames()) {
            VideoProfile profile = this.getVideoProfile(profileName);
            if (profile != null) {
                profiles.add(profile);
                continue;
            }
            log.debug("DAM video profile with name '{}' does not exist.", (Object)profileName);
        }
        return profiles;
    }

    private VideoProfile getVideoProfile(String profileName) {
        return VideoProfile.get((ResourceResolver)this.resourceResolver, (ConfigurationResourceResolver)this.configurationResourceResolver, (String)profileName);
    }

    @Nullable
    protected com.day.cq.dam.api.Asset getDamAsset(Media media) {
        Asset asset = media.getAsset();
        if (asset != null) {
            return (com.day.cq.dam.api.Asset)asset.adaptTo(com.day.cq.dam.api.Asset.class);
        }
        return null;
    }

    @Override
    public final HtmlElement build(@NotNull Media media) {
        return this.getVideoPlayerElement(media);
    }

    protected Video getVideoPlayerElement(@NotNull Media media) {
        Dimension dimension = MediaMarkupBuilderUtil.getMediaformatDimension(media);
        Video video = new Video();
        video.setWidth(dimension.getWidth());
        video.setHeight(dimension.getHeight());
        video.setControls(true);
        this.addSources(video, media);
        return video;
    }

    protected void addSources(Video video, Media media) {
        com.day.cq.dam.api.Asset asset = this.getDamAsset(media);
        if (asset == null) {
            return;
        }
        for (VideoProfile profile : this.getVideoProfiles()) {
            Rendition rendition = profile.getRendition(asset);
            if (rendition == null) continue;
            video.createSource().setType(profile.getHtmlType()).setSrc(this.urlHandler.get(rendition.getPath()).buildExternalResourceUrl((Resource)rendition.adaptTo(Resource.class)));
        }
    }

    protected Map<String, String> getAdditionalFlashPlayerParameters(Media media, Dimension dimension) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("allowFullScreen", "true");
        parameters.put("wmode", "opaque");
        return parameters;
    }

    protected Map<String, String> getAdditionalFlashPlayerFlashVars(Media media, Dimension dimension) {
        HashMap<String, String> flashvars = new HashMap<String, String>();
        flashvars.put("autoPlay", "false");
        flashvars.put("loop", "false");
        return flashvars;
    }

    @Override
    public final boolean isValidMedia(@NotNull HtmlElement element) {
        return element instanceof Video;
    }
}

