/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm;

import io.wcm.handler.media.Asset;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.mediasource.ngdm.NextGenDynamicMediaRendition;
import io.wcm.handler.mediasource.ngdm.NextGenDynamicMediaUriTemplate;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadata;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NextGenDynamicMediaAsset
implements Asset {
    private final NextGenDynamicMediaContext context;
    private final MediaArgs defaultMediaArgs;
    private final ValueMap properties;

    NextGenDynamicMediaAsset(@NotNull NextGenDynamicMediaContext context) {
        this.context = context;
        this.defaultMediaArgs = context.getDefaultMediaArgs();
        NextGenDynamicMediaMetadata metadata = context.getMetadata();
        this.properties = metadata != null ? metadata.getProperties() : ValueMap.EMPTY;
    }

    @Override
    @Nullable
    public String getTitle() {
        return StringUtils.defaultString((String)((String)this.properties.get("dc:title", String.class)), (String)this.context.getReference().getFileName());
    }

    @Override
    @Nullable
    public String getAltText() {
        if (this.defaultMediaArgs.isDecorative()) {
            return "";
        }
        if (!this.defaultMediaArgs.isForceAltValueFromAsset() && StringUtils.isNotEmpty((CharSequence)this.defaultMediaArgs.getAltText())) {
            return this.defaultMediaArgs.getAltText();
        }
        return StringUtils.defaultString((String)this.getDescription(), (String)this.getTitle());
    }

    @Override
    @Nullable
    public String getDescription() {
        return (String)this.properties.get("dc:description", String.class);
    }

    @Override
    @Nullable
    public String getPath() {
        return this.context.getReference().toReference();
    }

    @Override
    @NotNull
    public ValueMap getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public Rendition getDefaultRendition() {
        return this.getRendition(this.defaultMediaArgs);
    }

    @Override
    @Nullable
    public Rendition getRendition(@NotNull MediaArgs mediaArgs) {
        NextGenDynamicMediaRendition rendition = new NextGenDynamicMediaRendition(this.context, mediaArgs);
        if (StringUtils.isEmpty((CharSequence)rendition.getUrl())) {
            rendition = null;
        }
        return rendition;
    }

    @Override
    @Nullable
    public Rendition getImageRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isImage()) {
            return rendition;
        }
        return null;
    }

    @Override
    @Nullable
    public Rendition getDownloadRendition(@NotNull MediaArgs mediaArgs) {
        Rendition rendition = this.getRendition(mediaArgs);
        if (rendition != null && rendition.isDownload()) {
            return rendition;
        }
        return null;
    }

    @Override
    @NotNull
    public UriTemplate getUriTemplate(@NotNull UriTemplateType type) {
        return new NextGenDynamicMediaUriTemplate(this.context, type);
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        com.day.cq.dam.api.Asset asset = this.context.getReference().getAsset();
        if (asset != null) {
            if (type == com.day.cq.dam.api.Asset.class) {
                return (AdapterType)asset;
            }
            if (type == Resource.class) {
                return (AdapterType)asset.adaptTo(Resource.class);
            }
        }
        return null;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this).append("reference", (Object)this.context.getReference()).append("metadata", (Object)this.context.getMetadata());
        com.day.cq.dam.api.Asset asset = this.context.getReference().getAsset();
        if (asset != null) {
            sb.append("asset", (Object)asset.getPath());
        }
        return sb.toString();
    }
}

