/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaConfigService;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public final class NextGenDynamicMediaConfigModel {
    private static final JsonMapper MAPPER = (JsonMapper)JsonMapper.builder().build();
    private static final Logger log = LoggerFactory.getLogger(NextGenDynamicMediaConfigModel.class);
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private NextGenDynamicMediaConfigService config;
    private boolean enabled;
    private String assetSelectorsJsUrl;
    private String configJson;

    @PostConstruct
    private void activate() {
        if (this.config != null) {
            this.enabled = this.config.isEnabledRemoteAssets();
            this.assetSelectorsJsUrl = this.config.getAssetSelectorsJsUrl();
            this.configJson = NextGenDynamicMediaConfigModel.buildConfigJsonString(this.config);
        }
    }

    private static String buildConfigJsonString(@NotNull NextGenDynamicMediaConfigService config) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("repositoryId", config.getRemoteAssetsRepositoryId());
        map.put("apiKey", config.getApiKey());
        map.put("env", config.getEnv());
        try {
            return MAPPER.writeValueAsString(map);
        }
        catch (JsonProcessingException ex) {
            log.warn("Unable to serialize Dynamic Media with OpenAPI config to JSON.", (Throwable)ex);
            return "{}";
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public String getAssetSelectorsJsUrl() {
        return this.assetSelectorsJsUrl;
    }

    @Nullable
    public String getConfigJson() {
        return this.configJson;
    }
}

