/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm;

import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.EditConfig;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaInvalidReason;
import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.markup.MediaMarkupBuilderUtil;
import io.wcm.handler.media.spi.MediaHandlerConfig;
import io.wcm.handler.media.spi.MediaSource;
import io.wcm.handler.mediasource.ngdm.NextGenDynamicMediaAsset;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaConfigService;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaReference;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadata;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadataService;
import io.wcm.sling.models.annotations.AemObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ProviderType
public final class NextGenDynamicMediaMediaSource
extends MediaSource {
    @NotNull
    public static final String ID = "nextGenDynamicMedia";
    @Self
    private Adaptable adaptable;
    @Self
    private MediaHandlerConfig mediaHandlerConfig;
    @SlingObject
    private ResourceResolver resourceResolver;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private NextGenDynamicMediaConfigService nextGenDynamicMediaConfig;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private NextGenDynamicMediaMetadataService metadataService;
    @OSGiService
    private MimeTypeService mimeTypeService;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private WCMMode wcmMode;
    @AemObject(injectionStrategy=InjectionStrategy.OPTIONAL)
    private ComponentContext componentContext;
    private static final Logger log = LoggerFactory.getLogger(NextGenDynamicMediaMediaSource.class);

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    public boolean accepts(@Nullable String mediaRef) {
        if (this.nextGenDynamicMediaConfig == null) {
            return false;
        }
        return this.nextGenDynamicMediaConfig.isEnabledRemoteAssets() && NextGenDynamicMediaReference.isReference(mediaRef) || this.nextGenDynamicMediaConfig.isEnabledLocalAssets() && this.isDamAssetReference(mediaRef);
    }

    private boolean isDamAssetReference(@Nullable String mediaRef) {
        return StringUtils.startsWith((CharSequence)mediaRef, (CharSequence)"/content/dam/");
    }

    @Override
    @Nullable
    public String getPrimaryMediaRefProperty() {
        return this.mediaHandlerConfig.getMediaRefProperty();
    }

    @Override
    @NotNull
    public Media resolveMedia(@NotNull Media media) {
        String mediaRef = this.getMediaRef(media.getMediaRequest(), this.mediaHandlerConfig);
        MediaArgs mediaArgs = media.getMediaRequest().getMediaArgs();
        NextGenDynamicMediaReference reference = this.toNextGenDynamicMediaReference(mediaRef);
        if (reference == null || this.nextGenDynamicMediaConfig == null) {
            if (StringUtils.isEmpty((CharSequence)mediaRef)) {
                media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_MISSING);
            } else {
                media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_INVALID);
            }
            return media;
        }
        NextGenDynamicMediaMetadata metadata = null;
        if (this.metadataService != null && this.metadataService.isEnabled() && (metadata = this.metadataService.fetchMetadata(reference)) == null) {
            media.setMediaInvalidReason(MediaInvalidReason.MEDIA_REFERENCE_INVALID);
            return media;
        }
        if (metadata != null && !StringUtils.equals((CharSequence)metadata.getAssetStatus(), (CharSequence)"approved")) {
            log.trace("Reject asset with {}={} (expected: {})", new Object[]{"dam:status", metadata.getAssetStatus(), "approved"});
            media.setMediaInvalidReason(MediaInvalidReason.NOT_APPROVED);
            return media;
        }
        Resource referencedResource = media.getMediaRequest().getResource();
        if (referencedResource != null) {
            this.updateMediaArgsFromResource(mediaArgs, referencedResource, this.mediaHandlerConfig);
        }
        NextGenDynamicMediaContext context = new NextGenDynamicMediaContext(reference, metadata, media, mediaArgs, this.nextGenDynamicMediaConfig, this.mediaHandlerConfig, this.mimeTypeService);
        NextGenDynamicMediaAsset asset = new NextGenDynamicMediaAsset(context);
        media.setAsset(asset);
        boolean renditionsResolved = this.resolveRenditions(media, asset, mediaArgs);
        if (!renditionsResolved) {
            if (media.getRenditions().isEmpty()) {
                media.setMediaInvalidReason(MediaInvalidReason.NO_MATCHING_RENDITION);
            } else {
                media.setMediaInvalidReason(MediaInvalidReason.NOT_ENOUGH_MATCHING_RENDITIONS);
            }
        }
        return media;
    }

    @Nullable
    private NextGenDynamicMediaReference toNextGenDynamicMediaReference(@Nullable String mediaRef) {
        if (this.nextGenDynamicMediaConfig != null) {
            if (this.nextGenDynamicMediaConfig.isEnabledRemoteAssets() && NextGenDynamicMediaReference.isReference(mediaRef)) {
                return NextGenDynamicMediaReference.fromReference(mediaRef);
            }
            if (this.nextGenDynamicMediaConfig.isEnabledLocalAssets() && this.isDamAssetReference(mediaRef)) {
                return NextGenDynamicMediaReference.fromDamAssetReference(mediaRef, this.resourceResolver);
            }
        }
        return null;
    }

    @Override
    public void enableMediaDrop(@NotNull HtmlElement element, @NotNull MediaRequest mediaRequest) {
        if (this.wcmMode == WCMMode.DISABLED || this.wcmMode == null) {
            return;
        }
        if (this.componentContext != null && this.componentContext.getEditContext() != null) {
            EditConfig editConfig;
            if (MediaMarkupBuilderUtil.canApplyDragDropSupport(mediaRequest, this.componentContext)) {
                element.addCssClass("cq-dd-image");
            }
            if ((editConfig = this.componentContext.getEditContext().getEditConfig()) != null) {
                editConfig.setInplaceEditingConfig(null);
            }
        }
    }
}

