/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm;

import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.Rendition;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.impl.ImageQualityPercentage;
import io.wcm.handler.mediasource.ngdm.NextGenDynamicMediaUriTemplate;
import io.wcm.handler.mediasource.ngdm.impl.MediaArgsDimension;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaBinaryUrlBuilder;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaImageDeliveryParams;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaImageUrlBuilder;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaReference;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadata;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NextGenDynamicMediaRendition
implements Rendition {
    private final NextGenDynamicMediaContext context;
    private final NextGenDynamicMediaMetadata metadata;
    private final Dimension originalDimension;
    private final NextGenDynamicMediaReference reference;
    private final MediaArgs mediaArgs;
    private final String url;
    private MediaFormat resolvedMediaFormat;
    private long requestedWidth;
    private long requestedHeight;
    private long width;
    private long height;
    private String fileExtension;
    private static final Logger log = LoggerFactory.getLogger(NextGenDynamicMediaRendition.class);

    NextGenDynamicMediaRendition(@NotNull NextGenDynamicMediaContext context, @NotNull MediaArgs mediaArgs) {
        this.context = context;
        this.metadata = context.getMetadata();
        this.originalDimension = this.metadata != null ? this.metadata.getDimension() : null;
        this.reference = context.getReference();
        this.mediaArgs = mediaArgs;
        this.requestedWidth = mediaArgs.getFixedWidth();
        this.requestedHeight = mediaArgs.getFixedHeight();
        MediaFormat firstMediaFormat = MediaArgsDimension.getFirstMediaFormat(mediaArgs);
        if (firstMediaFormat != null) {
            this.resolvedMediaFormat = firstMediaFormat;
            if (this.requestedWidth == 0L) {
                this.requestedWidth = firstMediaFormat.getEffectiveMinWidth();
                this.requestedHeight = firstMediaFormat.getEffectiveMinHeight();
            }
        }
        this.fileExtension = mediaArgs.getEnforceOutputFileExtension();
        if (StringUtils.isEmpty((CharSequence)this.fileExtension)) {
            this.fileExtension = FilenameUtils.getExtension((String)this.reference.getFileName());
        }
        if (!this.isImage() || mediaArgs.isDownload()) {
            this.url = this.buildBinaryUrl();
        } else if (this.isVectorImage()) {
            this.calculateWidthHeightVectorImage();
            this.url = this.buildBinaryUrl();
        } else {
            this.calculateWidthHeight();
            if (this.isRequestedDimensionLargerThanOriginal()) {
                this.url = null;
            } else {
                this.url = this.buildImageRenditionUrl();
                this.fileExtension = new NextGenDynamicMediaImageUrlBuilder(context).getFileExtension();
            }
        }
    }

    private void calculateWidthHeight() {
        double requestedRatio = MediaArgsDimension.getRequestedRatio(this.mediaArgs);
        if (this.requestedWidth > 0L && this.requestedHeight > 0L) {
            this.width = this.requestedWidth;
            this.height = this.requestedHeight;
        } else if (this.requestedWidth == 0L && this.requestedHeight == 0L && this.originalDimension != null) {
            this.width = this.originalDimension.getWidth();
            this.height = this.originalDimension.getHeight();
        } else if (this.requestedWidth > 0L && this.requestedHeight == 0L) {
            this.width = this.requestedWidth;
            if (requestedRatio > 0.0) {
                this.requestedHeight = this.height = Math.round((double)this.requestedWidth / requestedRatio);
            } else if (this.originalDimension != null) {
                this.height = Math.round((double)this.requestedWidth / Ratio.get(this.originalDimension));
            }
        } else if (this.requestedHeight > 0L && this.requestedWidth == 0L) {
            this.height = this.requestedHeight;
            if (requestedRatio > 0.0) {
                this.requestedWidth = this.width = Math.round((double)this.requestedHeight * requestedRatio);
            } else if (this.originalDimension != null) {
                this.width = Math.round((double)this.requestedHeight * Ratio.get(this.originalDimension));
            }
        }
    }

    private void calculateWidthHeightVectorImage() {
        if (this.originalDimension != null) {
            this.width = this.originalDimension.getWidth();
            this.height = this.originalDimension.getHeight();
        } else {
            this.calculateWidthHeight();
        }
    }

    private String buildImageRenditionUrl() {
        Dimension ratioDimension;
        NextGenDynamicMediaImageDeliveryParams params = new NextGenDynamicMediaImageDeliveryParams().rotation(this.context.getMedia().getRotation()).quality(ImageQualityPercentage.getAsInteger(this.mediaArgs, this.context.getMediaHandlerConfig()));
        if (this.requestedWidth > 0L) {
            params.width(this.requestedWidth);
        }
        if (this.requestedHeight > 0L) {
            params.height(this.requestedHeight);
        }
        if ((ratioDimension = MediaArgsDimension.getRequestedRatioAsWidthHeight(this.mediaArgs)) != null) {
            params.ratio(ratioDimension);
        }
        return new NextGenDynamicMediaImageUrlBuilder(this.context).build(params);
    }

    private boolean isRequestedDimensionLargerThanOriginal() {
        if (this.originalDimension != null && (this.requestedWidth > this.originalDimension.getWidth() || this.requestedHeight > this.originalDimension.getHeight())) {
            if (log.isTraceEnabled()) {
                log.trace("Requested dimension {} is larger than original image dimension {} of {}", new Object[]{new Dimension(this.requestedWidth, this.requestedHeight), this.originalDimension, this.context.getReference()});
            }
            return true;
        }
        return false;
    }

    private String buildBinaryUrl() {
        return new NextGenDynamicMediaBinaryUrlBuilder(this.context).build(this.mediaArgs.isContentDispositionAttachment());
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public String getPath() {
        return null;
    }

    @Override
    @Nullable
    public String getFileName() {
        return this.reference.getFileName();
    }

    @Override
    @Nullable
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public long getFileSize() {
        Long fileSize;
        if (this.metadata != null && (fileSize = this.metadata.getFileSize()) != null) {
            return fileSize;
        }
        return -1L;
    }

    @Override
    @Nullable
    public String getMimeType() {
        if (this.metadata != null) {
            return this.metadata.getMimeType();
        }
        return this.context.getMimeTypeService().getMimeType(this.getFileExtension());
    }

    @Override
    @Nullable
    public MediaFormat getMediaFormat() {
        return this.resolvedMediaFormat;
    }

    @Override
    @NotNull
    public ValueMap getProperties() {
        return ValueMap.EMPTY;
    }

    @Override
    public boolean isImage() {
        return MediaFileType.isImage(this.getFileExtension());
    }

    @Override
    public boolean isBrowserImage() {
        return MediaFileType.isBrowserImage(this.getFileExtension());
    }

    @Override
    public boolean isVectorImage() {
        return MediaFileType.isVectorImage(this.getFileExtension());
    }

    @Override
    public boolean isDownload() {
        return !this.isImage();
    }

    @Override
    public long getWidth() {
        return this.width;
    }

    @Override
    public long getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    public Date getModificationDate() {
        return null;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    @NotNull
    public UriTemplate getUriTemplate(@NotNull UriTemplateType type) {
        if (!this.isImage() || this.isVectorImage()) {
            throw new UnsupportedOperationException("Unable to build URI template for " + this.reference.toReference());
        }
        return new NextGenDynamicMediaUriTemplate(this.context, type);
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> arg0) {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Objects.toString(this.url, "#invalid"));
        if (this.width > 0L || this.height > 0L) {
            sb.append(" (").append(Long.toString(this.width)).append("x").append(Long.toString(this.height)).append(")");
        }
        return sb.toString();
    }
}

