/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm;

import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.impl.ImageQualityPercentage;
import io.wcm.handler.mediasource.ngdm.impl.MediaArgsDimension;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaImageDeliveryParams;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaImageUrlBuilder;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadata;
import org.jetbrains.annotations.NotNull;

final class NextGenDynamicMediaUriTemplate
implements UriTemplate {
    private final UriTemplateType type;
    private final String uriTemplate;
    private final Dimension dimension;

    NextGenDynamicMediaUriTemplate(@NotNull NextGenDynamicMediaContext context, @NotNull UriTemplateType type) {
        this.type = type;
        NextGenDynamicMediaMetadata metadata = context.getMetadata();
        this.dimension = metadata != null ? metadata.getDimension() : null;
        NextGenDynamicMediaImageDeliveryParams params = new NextGenDynamicMediaImageDeliveryParams().rotation(context.getMedia().getRotation()).quality(ImageQualityPercentage.getAsInteger(context.getDefaultMediaArgs(), context.getMediaHandlerConfig()));
        if (type == UriTemplateType.SCALE_HEIGHT) {
            params.heightPlaceholder("{height}");
        } else {
            params.widthPlaceholder("{width}");
        }
        Dimension ratio = MediaArgsDimension.getRequestedRatioAsWidthHeight(context.getDefaultMediaArgs());
        if (ratio != null) {
            params.ratio(ratio);
        }
        this.uriTemplate = new NextGenDynamicMediaImageUrlBuilder(context).build(params);
    }

    @Override
    @NotNull
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    @Override
    @NotNull
    public UriTemplateType getType() {
        return this.type;
    }

    @Override
    public long getMaxWidth() {
        if (this.dimension != null) {
            return this.dimension.getWidth();
        }
        return 0L;
    }

    @Override
    public long getMaxHeight() {
        if (this.dimension != null) {
            return this.dimension.getHeight();
        }
        return 0L;
    }
}

