/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl;

import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NextGenDynamicMediaBinaryUrlBuilder {
    private final NextGenDynamicMediaContext context;
    static final String PARAM_ATTACHMENT = "attachment";

    public NextGenDynamicMediaBinaryUrlBuilder(@NotNull NextGenDynamicMediaContext context) {
        this.context = context;
    }

    @Nullable
    public String build(boolean contentDispositionAttachment) {
        String binaryDeliveryPath;
        String repositoryId = this.context.getReference().getAsset() != null ? this.context.getNextGenDynamicMediaConfig().getLocalAssetsRepositoryId() : this.context.getNextGenDynamicMediaConfig().getRemoteAssetsRepositoryId();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{repositoryId, binaryDeliveryPath = this.context.getNextGenDynamicMediaConfig().getAssetOriginalBinaryDeliveryPath()})) {
            return null;
        }
        String seoName = this.context.getReference().getFileName();
        binaryDeliveryPath = StringUtils.replace((String)binaryDeliveryPath, (String)"{asset-id}", (String)this.context.getReference().getAssetId());
        binaryDeliveryPath = StringUtils.replace((String)binaryDeliveryPath, (String)"{seo-name}", (String)seoName);
        StringBuilder url = new StringBuilder();
        url.append("https://").append(repositoryId).append(binaryDeliveryPath);
        if (contentDispositionAttachment) {
            url.append("?").append(PARAM_ATTACHMENT).append("=true");
        }
        return url.toString();
    }
}

