/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl;

import com.adobe.cq.ui.wcm.commons.config.NextGenDynamicMediaConfig;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaConfigService;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={NextGenDynamicMediaConfigService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class NextGenDynamicMediaConfigServiceImpl
implements NextGenDynamicMediaConfigService {
    private static final String ADOBE_ASSETS_PREFIX = "/adobe/assets/";
    private static final Logger log = LoggerFactory.getLogger(NextGenDynamicMediaConfigServiceImpl.class);
    private boolean enabledRemoteAssets;
    private boolean enabledLocalAssets;
    private String localAssetsRepositoryId;
    private String imageDeliveryBasePath;
    private String assetOriginalBinaryDeliveryPath;
    private String assetMetadataPath;
    private long imageWidthHeightDefault;
    @Reference(policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    private NextGenDynamicMediaConfig nextGenDynamicMediaConfig;

    @Activate
    private void activate(Config config) {
        this.enabledRemoteAssets = config.enabledRemoteAssets();
        if (this.enabledRemoteAssets) {
            if (this.nextGenDynamicMediaConfig == null) {
                log.debug("NextGenDynamicMediaConfig service is not available, disable remote assets.");
                this.enabledRemoteAssets = false;
            } else {
                log.debug("NextGenDynamicMediaConfig: enabled={}, repositoryId={}, apiKey={}, env={}, imsClient={}", new Object[]{this.nextGenDynamicMediaConfig.enabled(), this.nextGenDynamicMediaConfig.getRepositoryId(), this.nextGenDynamicMediaConfig.getApiKey(), this.nextGenDynamicMediaConfig.getEnv(), this.nextGenDynamicMediaConfig.getImsClient()});
            }
        }
        this.imageDeliveryBasePath = (String)StringUtils.defaultIfBlank((CharSequence)config.imageDeliveryBasePath(), this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getImageDeliveryBasePath() : null);
        this.assetOriginalBinaryDeliveryPath = (String)StringUtils.defaultIfBlank((CharSequence)config.assetOriginalBinaryDeliveryPath(), this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getAssetOriginalBinaryDeliveryPath() : null);
        this.assetMetadataPath = (String)StringUtils.defaultIfBlank((CharSequence)config.assetMetadataPath(), this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getAssetMetadataPath() : null);
        this.enabledLocalAssets = config.enabledLocalAssets();
        this.localAssetsRepositoryId = config.localAssetsRepositoryId();
        if (this.enabledLocalAssets && StringUtils.isBlank((CharSequence)this.localAssetsRepositoryId)) {
            log.debug("localAssetsRepositoryId is not configured, disable local assets.");
            this.enabledLocalAssets = false;
        }
        this.imageWidthHeightDefault = config.imageWidthHeightDefault();
    }

    @Override
    public boolean isEnabledRemoteAssets() {
        return this.enabledRemoteAssets && this.nextGenDynamicMediaConfig != null && this.nextGenDynamicMediaConfig.enabled();
    }

    @Override
    public boolean isEnabledLocalAssets() {
        return this.enabledLocalAssets;
    }

    @Override
    @Nullable
    public String getAssetSelectorsJsUrl() {
        return this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getAssetSelectorsJsUrl() : null;
    }

    @Override
    @Nullable
    public String getImageDeliveryBasePath() {
        return this.imageDeliveryBasePath;
    }

    @Override
    @Nullable
    public String getVideoDeliveryPath() {
        return this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getVideoDeliveryPath() : null;
    }

    @Override
    @Nullable
    public String getAssetOriginalBinaryDeliveryPath() {
        return this.assetOriginalBinaryDeliveryPath;
    }

    @Override
    @Nullable
    public String getAssetMetadataPath() {
        return this.assetMetadataPath;
    }

    @Override
    @Nullable
    public String getRemoteAssetsRepositoryId() {
        return this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getRepositoryId() : null;
    }

    @Override
    @Nullable
    public String getLocalAssetsRepositoryId() {
        return this.localAssetsRepositoryId;
    }

    @Override
    @Nullable
    public String getApiKey() {
        return this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getApiKey() : null;
    }

    @Override
    @Nullable
    public String getEnv() {
        return this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getEnv() : null;
    }

    @Override
    @Nullable
    public String getImsClient() {
        return this.nextGenDynamicMediaConfig != null ? this.nextGenDynamicMediaConfig.getImsClient() : null;
    }

    @Override
    public long getImageWidthHeightDefault() {
        return this.imageWidthHeightDefault;
    }

    @ObjectClassDefinition(name="wcm.io Media Handler Dynamic Media with OpenAPI Support", description="Support for Dynamic Media with OpenAPI.")
    static @interface Config {
        @AttributeDefinition(name="Remote Assets", description="Enable Dynamic Media with OpenAPI for remote assets.")
        public boolean enabledRemoteAssets() default false;

        @AttributeDefinition(name="Local Assets", description="Enable Next Dynamic Media with OpenAPI for local assets in this AEMaaCS instance.")
        public boolean enabledLocalAssets() default false;

        @AttributeDefinition(name="Repository ID for Local Assets", description="Dynamic Media with OpenAPI Delivery host name for local assets. Mandatory if local assets is enabled.")
        public String localAssetsRepositoryId();

        @AttributeDefinition(name="Image Delivery Base Path", description="Base path with placeholders to deliver image renditions. Placeholders: {asset-id}, {seo-name}, {format}. If not set, the default value from the NextGenDynamicMediaConfig service will be used.")
        public String imageDeliveryBasePath() default "/adobe/assets/{asset-id}/as/{seo-name}.{format}";

        @AttributeDefinition(name="Asset Original Binary Delivery Path", description="Base path with placeholders to deliver asset original binaries. Placeholders: {asset-id}, {seo-name}. If not set, the default value from the NextGenDynamicMediaConfig service will be used.")
        public String assetOriginalBinaryDeliveryPath() default "/adobe/assets/{asset-id}/original/as/{seo-name}";

        @AttributeDefinition(name="Asset Metadata Path", description="Base path to get asset metadata. Placeholder: {asset-id}. If not set, the default value from the NextGenDynamicMediaConfig service will be used.")
        public String assetMetadataPath() default "/adobe/assets/{asset-id}/metadata";

        @AttributeDefinition(name="Default image width/height", description="Default width/height (longest edge) when requesting image renditions without explicit dimension.")
        public long imageWidthHeightDefault() default 2048L;
    }
}

