/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.impl.ImageTransformation;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaContext;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaImageDeliveryParams;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadata;
import io.wcm.handler.mediasource.ngdm.impl.metadata.SmartCrop;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NextGenDynamicMediaImageUrlBuilder {
    static final String PARAM_PREFER_WEBP = "preferwebp";
    static final String PARAM_WIDTH = "width";
    static final String PARAM_HEIGHT = "height";
    static final String PARAM_CROP = "crop";
    static final String PARAM_SMARTCROP = "smartcrop";
    static final String PARAM_ROTATE = "rotate";
    static final String PARAM_QUALITY = "quality";
    private static final Set<String> SUPPORTED_FORMATS = Set.of("jpg", "png", "gif", "webp");
    private final NextGenDynamicMediaContext context;

    public NextGenDynamicMediaImageUrlBuilder(@NotNull NextGenDynamicMediaContext context) {
        this.context = context;
    }

    @Nullable
    public String build(@NotNull NextGenDynamicMediaImageDeliveryParams params) {
        Integer quality;
        String repositoryId = this.context.getReference().getAsset() != null ? this.context.getNextGenDynamicMediaConfig().getLocalAssetsRepositoryId() : this.context.getNextGenDynamicMediaConfig().getRemoteAssetsRepositoryId();
        String imageDeliveryPath = this.context.getNextGenDynamicMediaConfig().getImageDeliveryBasePath();
        if (repositoryId == null || imageDeliveryPath == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{repositoryId, imageDeliveryPath})) {
            return null;
        }
        String seoName = FilenameUtils.getBaseName((String)this.context.getReference().getFileName());
        String format = this.getFileExtension();
        imageDeliveryPath = StringUtils.replace((String)imageDeliveryPath, (String)"{asset-id}", (String)this.context.getReference().getAssetId());
        imageDeliveryPath = StringUtils.replace((String)imageDeliveryPath, (String)"{seo-name}", (String)seoName);
        imageDeliveryPath = StringUtils.replace((String)imageDeliveryPath, (String)"{format}", (String)format);
        TreeMap<String, String> urlParamMap = new TreeMap<String, String>();
        urlParamMap.put(PARAM_PREFER_WEBP, "true");
        this.applyWidthHeightCroppingParams(params, urlParamMap);
        Integer rotation = params.getRotation();
        if (rotation != null && rotation != 0) {
            urlParamMap.put(PARAM_ROTATE, rotation.toString());
        }
        if ((quality = params.getQuality()) != null) {
            urlParamMap.put(PARAM_QUALITY, quality.toString());
        }
        return NextGenDynamicMediaImageUrlBuilder.buildImageUrl(repositoryId, imageDeliveryPath, urlParamMap);
    }

    @NotNull
    private static String buildImageUrl(@NotNull String repositoryId, @NotNull String imageDeliveryPath, @NotNull SortedMap<String, String> urlParamMap) {
        StringBuilder url = new StringBuilder();
        url.append("https://").append(repositoryId).append(imageDeliveryPath);
        String urlParams = urlParamMap.entrySet().stream().map(entry -> NextGenDynamicMediaImageUrlBuilder.toUrlParam((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.joining("&"));
        if (StringUtils.isNotEmpty((CharSequence)urlParams)) {
            if (url.indexOf("?") < 0) {
                url.append("?");
            } else {
                url.append("&");
            }
            url.append(urlParams);
        }
        return url.toString();
    }

    @NotNull
    private static String toUrlParam(@NotNull String key, @NotNull String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append("=");
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{PARAM_CROP, PARAM_SMARTCROP})) {
            sb.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    private void applyWidthHeightCroppingParams(@NotNull NextGenDynamicMediaImageDeliveryParams params, @NotNull SortedMap<String, String> urlParamMap) {
        Dimension requestedRatio;
        SmartCrop namedSmartCrop;
        NextGenDynamicMediaMetadata metadata = this.context.getMetadata();
        Dimension orginalDimension = null;
        if (metadata != null) {
            orginalDimension = metadata.getDimension();
        }
        if ((namedSmartCrop = this.getMatchingNamedSmartCrop(metadata, requestedRatio = params.getRatio())) != null) {
            boolean widthOrHeightDefined;
            urlParamMap.put(PARAM_SMARTCROP, namedSmartCrop.getName());
            boolean bl = widthOrHeightDefined = this.applyWidthOrPlaceholder(params, urlParamMap) || this.applyHeightOrPlaceholder(params, urlParamMap);
            if (!widthOrHeightDefined) {
                String imageWidthHeightDefault = Long.toString(this.context.getNextGenDynamicMediaConfig().getImageWidthHeightDefault());
                if (namedSmartCrop.getCropDimension().getWidth() >= namedSmartCrop.getCropDimension().getHeight()) {
                    urlParamMap.put(PARAM_WIDTH, imageWidthHeightDefault);
                } else {
                    urlParamMap.put(PARAM_HEIGHT, imageWidthHeightDefault);
                }
            }
        } else if (orginalDimension != null && requestedRatio != null && this.isAutoCroppingRequired(orginalDimension, requestedRatio)) {
            CropDimension cropDimension = ImageTransformation.calculateAutoCropDimension(orginalDimension.getWidth(), orginalDimension.getHeight(), Ratio.get(requestedRatio));
            urlParamMap.put(PARAM_CROP, cropDimension.getCropStringWidthHeight());
            if (!this.applyWidthOrPlaceholder(params, urlParamMap)) {
                this.applyHeightOrPlaceholder(params, urlParamMap);
            }
        } else {
            boolean widthDefined = this.applyWidthOrPlaceholder(params, urlParamMap);
            boolean heightDefined = this.applyHeightOrPlaceholder(params, urlParamMap);
            if (!widthDefined && !heightDefined && requestedRatio != null) {
                double ratio = Ratio.get(requestedRatio);
                long width = this.context.getNextGenDynamicMediaConfig().getImageWidthHeightDefault();
                long height = this.context.getNextGenDynamicMediaConfig().getImageWidthHeightDefault();
                if (ratio > 1.0) {
                    height = Math.round((double)width / ratio);
                } else if (ratio < 1.0) {
                    width = Math.round((double)height * ratio);
                }
                urlParamMap.put(PARAM_WIDTH, Long.toString(width));
                urlParamMap.put(PARAM_HEIGHT, Long.toString(height));
            }
        }
    }

    @Nullable
    private SmartCrop getMatchingNamedSmartCrop(@Nullable NextGenDynamicMediaMetadata metadata, @Nullable Dimension cropSmartRatio) {
        if (metadata == null || cropSmartRatio == null) {
            return null;
        }
        double requestedRatio = Ratio.get(cropSmartRatio);
        return metadata.getSmartCrops().stream().filter(smartCrop -> Ratio.matches(smartCrop.getRatio(), requestedRatio)).findFirst().orElse(null);
    }

    private boolean isAutoCroppingRequired(@NotNull Dimension originalDimension, @NotNull Dimension cropSmartRatio) {
        return !Ratio.matches(Ratio.get(originalDimension), Ratio.get(cropSmartRatio));
    }

    private boolean applyWidthOrPlaceholder(@NotNull NextGenDynamicMediaImageDeliveryParams params, @NotNull SortedMap<String, String> urlParamMap) {
        Long width = params.getWidth();
        String widthPlaceholder = params.getWidthPlaceholder();
        boolean anyApplied = false;
        if (widthPlaceholder != null) {
            urlParamMap.put(PARAM_WIDTH, widthPlaceholder);
            anyApplied = true;
        } else if (width != null) {
            urlParamMap.put(PARAM_WIDTH, width.toString());
            anyApplied = true;
        }
        return anyApplied;
    }

    private boolean applyHeightOrPlaceholder(@NotNull NextGenDynamicMediaImageDeliveryParams params, @NotNull SortedMap<String, String> urlParamMap) {
        Long height = params.getHeight();
        String heightPlaceholder = params.getHeightPlaceholder();
        boolean anyApplied = false;
        if (heightPlaceholder != null) {
            urlParamMap.put(PARAM_HEIGHT, heightPlaceholder);
            anyApplied = true;
        } else if (height != null) {
            urlParamMap.put(PARAM_HEIGHT, height.toString());
            anyApplied = true;
        }
        return anyApplied;
    }

    @NotNull
    public String getFileExtension() {
        String format = this.context.getDefaultMediaArgs().getEnforceOutputFileExtension();
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = StringUtils.toRootLowerCase((String)FilenameUtils.getExtension((String)this.context.getReference().getFileName()));
        }
        if (format == null || !SUPPORTED_FORMATS.contains(format)) {
            format = "jpg";
        }
        return format;
    }
}

