/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl;

import com.day.cq.dam.api.Asset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NextGenDynamicMediaReference {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("^/(urn:[^/]+)/([^/]+)$");
    private static final String ASSET_ID_PREFIX = "urn:";
    private final String assetId;
    private final String fileName;
    private final Asset asset;
    private static final Logger log = LoggerFactory.getLogger(NextGenDynamicMediaReference.class);

    public NextGenDynamicMediaReference(@NotNull String assetId, @NotNull String fileName) {
        this(assetId, fileName, null);
    }

    public NextGenDynamicMediaReference(@NotNull String assetId, @NotNull String fileName, @Nullable Asset asset) {
        if (!StringUtils.startsWith((CharSequence)assetId, (CharSequence)ASSET_ID_PREFIX)) {
            throw new IllegalArgumentException("Asset ID must start with 'urn:'");
        }
        this.assetId = assetId;
        this.fileName = fileName;
        this.asset = asset;
    }

    @NotNull
    public String getAssetId() {
        return this.assetId;
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @Nullable
    public Asset getAsset() {
        return this.asset;
    }

    public boolean isLocal() {
        return this.asset != null;
    }

    @NotNull
    public String toReference() {
        return "/" + this.assetId + "/" + this.fileName;
    }

    @Nullable
    public static NextGenDynamicMediaReference fromReference(@Nullable String reference) {
        if (reference == null) {
            return null;
        }
        Matcher matcher = REFERENCE_PATTERN.matcher(reference);
        if (!matcher.matches()) {
            return null;
        }
        String assetId = matcher.group(1);
        String fileName = matcher.group(2);
        return new NextGenDynamicMediaReference(assetId, fileName);
    }

    @Nullable
    public static NextGenDynamicMediaReference fromDamAssetReference(@Nullable String reference, @NotNull ResourceResolver resourceResolver) {
        if (reference == null) {
            return null;
        }
        Resource resource = resourceResolver.getResource(reference);
        if (resource == null) {
            return null;
        }
        Asset asset = (Asset)resource.adaptTo(Asset.class);
        if (asset == null) {
            return null;
        }
        String uuid = asset.getID();
        if (StringUtils.isBlank((CharSequence)uuid)) {
            log.trace("Ignoring DAM asset without UUID: {}", (Object)asset.getPath());
            return null;
        }
        String assetId = "urn:aaid:aem:" + uuid;
        String fileName = asset.getName();
        return new NextGenDynamicMediaReference(assetId, fileName, asset);
    }

    public static boolean isReference(@Nullable String reference) {
        return reference != null && REFERENCE_PATTERN.matcher(reference).matches();
    }

    public String toString() {
        return this.toReference();
    }
}

