/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl.metadata;

import com.fasterxml.jackson.databind.json.JsonMapper;
import io.wcm.handler.media.shaded.com.github.benmanes.caffeine.cache.Cache;
import io.wcm.handler.media.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import io.wcm.handler.media.shaded.com.github.benmanes.caffeine.cache.Expiry;
import io.wcm.handler.mediasource.ngdm.impl.metadata.AccessTokenResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImsAccessTokenCache {
    private static final long EXPERIATION_BUFFER_SEC = 5L;
    private final Cache<String, AccessTokenResponse> tokenCache = Caffeine.newBuilder().expireAfter(new Expiry<String, AccessTokenResponse>(){

        @Override
        public long expireAfterCreate(String key, AccessTokenResponse value, long currentTime) {
            return TimeUnit.SECONDS.toNanos(value.expiresInSec - 5L);
        }

        @Override
        public long expireAfterUpdate(String key, AccessTokenResponse value, long currentTime, long currentDuration) {
            return Long.MAX_VALUE;
        }

        @Override
        public long expireAfterRead(String key, AccessTokenResponse value, long currentTime, long currentDuration) {
            return Long.MAX_VALUE;
        }
    }).build();
    private static final JsonMapper OBJECT_MAPPER = new JsonMapper();
    private static final Logger log = LoggerFactory.getLogger(ImsAccessTokenCache.class);
    private final CloseableHttpClient httpClient;
    private final String imsTokenApiUrl;

    ImsAccessTokenCache(@NotNull CloseableHttpClient httpClient, @NotNull String imsTokenApiUrl) {
        this.httpClient = httpClient;
        this.imsTokenApiUrl = imsTokenApiUrl;
    }

    @Nullable
    public String getAccessToken(@NotNull String clientId, @NotNull String clientSecret, @NotNull String scope) {
        String key = clientId + "::" + scope;
        AccessTokenResponse accessTokenResponse = this.tokenCache.get(key, k -> this.createAccessToken(clientId, clientSecret, scope));
        if (accessTokenResponse != null) {
            return accessTokenResponse.accessToken;
        }
        return null;
    }

    @Nullable
    private AccessTokenResponse createAccessToken(@NotNull String clientId, @NotNull String clientSecret, @NotNull String scope) {
        AccessTokenResponse accessTokenResponse;
        block8: {
            ArrayList<BasicNameValuePair> formData = new ArrayList<BasicNameValuePair>();
            formData.add(new BasicNameValuePair("grant_type", "client_credentials"));
            formData.add(new BasicNameValuePair("client_id", clientId));
            formData.add(new BasicNameValuePair("client_secret", clientSecret));
            formData.add(new BasicNameValuePair("scope", scope));
            HttpPost httpPost = new HttpPost(this.imsTokenApiUrl);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formData, StandardCharsets.UTF_8));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            try {
                accessTokenResponse = this.processResponse(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    log.warn("Unable to obtain access token from URL {}", (Object)this.imsTokenApiUrl, (Object)ex);
                    return null;
                }
            }
            response.close();
        }
        return accessTokenResponse;
    }

    @Nullable
    private AccessTokenResponse processResponse(@NotNull CloseableHttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 200) {
            String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity());
            AccessTokenResponse accessTokenResponse = (AccessTokenResponse)OBJECT_MAPPER.readValue(jsonResponse, AccessTokenResponse.class);
            log.trace("HTTP response for access token reqeust from {} returned a response, expires in {} sec", (Object)this.imsTokenApiUrl, (Object)accessTokenResponse.expiresInSec);
            return accessTokenResponse;
        }
        log.warn("Unexpected HTTP response for access token request from {}: {}", (Object)this.imsTokenApiUrl, (Object)response.getStatusLine());
        return null;
    }
}

