/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.mediasource.ngdm.impl.metadata.MetadataResponse;
import io.wcm.handler.mediasource.ngdm.impl.metadata.SmartCrop;
import io.wcm.wcm.commons.util.ToStringStyle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NextGenDynamicMediaMetadata {
    private final String mimeType;
    private final Long fileSize;
    private final Dimension dimension;
    private final String assetStatus;
    private final ValueMap properties;
    private final List<SmartCrop> smartCrops;
    private static final JsonMapper OBJECT_MAPPER = new JsonMapper();
    static final String RT_RENDITION_SMARTCROP = "dam/rendition/smartcrop";

    NextGenDynamicMediaMetadata(@Nullable String mimeType, @Nullable Long fileSize, @Nullable Dimension dimension, @Nullable String assetStatus, @Nullable ValueMap properties, @Nullable List<SmartCrop> smartCrops) {
        this.mimeType = mimeType;
        this.fileSize = fileSize;
        this.dimension = dimension;
        this.assetStatus = assetStatus;
        this.properties = properties != null ? properties : ValueMap.EMPTY;
        this.smartCrops = smartCrops != null ? smartCrops : Collections.emptyList();
    }

    @NotNull
    public String getMimeType() {
        return Objects.toString(this.mimeType, "application/octet-stream");
    }

    @Nullable
    public Long getFileSize() {
        return this.fileSize;
    }

    @Nullable
    public Dimension getDimension() {
        return this.dimension;
    }

    public String getAssetStatus() {
        return this.assetStatus;
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public List<SmartCrop> getSmartCrops() {
        return Collections.unmodifiableList(this.smartCrops);
    }

    public boolean isValid() {
        return this.mimeType != null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_OMIT_NULL_STYLE).append("mimeType", (Object)this.mimeType).append("fileSize", (Object)this.fileSize).append("dimension", (Object)this.dimension).append("assetStatus", (Object)this.assetStatus).append("properties", (Object)(this.properties.isEmpty() ? null : new TreeMap(this.properties))).append("smartCrops", this.smartCrops.isEmpty() ? null : this.smartCrops).toString();
    }

    @NotNull
    public static NextGenDynamicMediaMetadata fromJson(@NotNull String jsonResponse) throws JsonProcessingException {
        MetadataResponse response = (MetadataResponse)OBJECT_MAPPER.readValue(jsonResponse, MetadataResponse.class);
        MetadataResponse.RepositoryMetadata respositoryMetadata = response.repositoryMetadata;
        Map<String, Object> assetMetadata = response.assetMetadata;
        ValueMapDecorator properties = null;
        long width = 0L;
        long height = 0L;
        String assetStatus = null;
        if (assetMetadata != null) {
            properties = new ValueMapDecorator(assetMetadata);
            width = (Long)properties.get("tiff:ImageWidth", (Object)0L);
            height = (Long)properties.get("tiff:ImageLength", (Object)0L);
            assetStatus = (String)properties.get("dam:assetStatus", String.class);
        }
        Dimension dimension = NextGenDynamicMediaMetadata.toDimension(width, height);
        String mimeType = null;
        Long fileSize = null;
        List smartCrops = null;
        if (respositoryMetadata != null) {
            mimeType = respositoryMetadata.dcFormat;
            fileSize = respositoryMetadata.repoSize;
            if (respositoryMetadata.smartCrops != null && dimension != null) {
                smartCrops = respositoryMetadata.smartCrops.entrySet().stream().filter(entry -> NextGenDynamicMediaMetadata.isSmartCropDefinitionValid((String)entry.getKey(), (MetadataResponse.SmartCrop)entry.getValue())).map(entry -> new SmartCrop((String)entry.getKey(), (MetadataResponse.SmartCrop)entry.getValue(), dimension)).collect(Collectors.toList());
            }
        }
        return new NextGenDynamicMediaMetadata(mimeType, fileSize, dimension, assetStatus, (ValueMap)properties, smartCrops);
    }

    @Nullable
    private static Dimension toDimension(long width, long height) {
        if (width > 0L && height > 0L) {
            return new Dimension(width, height);
        }
        return null;
    }

    private static boolean isSmartCropDefinitionValid(@NotNull String name, @NotNull MetadataResponse.SmartCrop smartCop) {
        return StringUtils.isNotBlank((CharSequence)name) && smartCop.normalizedWidth > 0.0 && smartCop.normalizedHeight > 0.0 && smartCop.left >= 0.0 && smartCop.top >= 0.0;
    }
}

