/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl.metadata;

import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaConfigService;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaReference;
import io.wcm.handler.mediasource.ngdm.impl.metadata.ImsAccessTokenCache;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadata;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadataService;
import io.wcm.handler.mediasource.ngdm.impl.metadata.NextGenDynamicMediaMetadataUrlBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={NextGenDynamicMediaMetadataService.class}, immediate=true)
@Designate(ocd=Config.class)
public class NextGenDynamicMediaMetadataServiceImpl
implements NextGenDynamicMediaMetadataService {
    @Reference
    private NextGenDynamicMediaConfigService nextGenDynamicMediaConfig;
    private boolean enabled;
    private CloseableHttpClient httpClient;
    private ImsAccessTokenCache imsAccessTokenCache;
    private String authenticationClientId;
    private String authenticationClientSecret;
    private String authenticationScope;
    private static final Logger log = LoggerFactory.getLogger(NextGenDynamicMediaMetadataServiceImpl.class);

    @Activate
    private void activate(Config config) {
        this.enabled = config.enabled();
        if (this.enabled) {
            this.httpClient = NextGenDynamicMediaMetadataServiceImpl.createHttpClient(config);
            String imsTokenApiUrl = config.imsTokenApiUrl();
            this.authenticationClientId = config.authenticationClientId();
            this.authenticationClientSecret = config.authenticationClientSecret();
            this.authenticationScope = config.authenticationScope();
            if (log.isTraceEnabled()) {
                log.trace("Authentication configuration: imsTokenApiUrl={}, authenticationClientId={}, authenticationClientSecret={}, authenticationScope={}", new Object[]{StringUtils.defaultString((String)imsTokenApiUrl), StringUtils.isNotBlank((CharSequence)this.authenticationClientId) ? "***" : "", StringUtils.isNotBlank((CharSequence)this.authenticationClientSecret) ? "***" : "", StringUtils.defaultString((String)this.authenticationScope)});
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{imsTokenApiUrl, this.authenticationClientId, this.authenticationClientSecret, this.authenticationScope})) {
                log.debug("Enable IMS access token fetching for NGDM asset metadata.");
                this.imsAccessTokenCache = new ImsAccessTokenCache(this.httpClient, config.imsTokenApiUrl());
            } else {
                log.debug("IMS access token fetching for NGDM asset metadata is disabled.");
            }
        }
    }

    private static CloseableHttpClient createHttpClient(Config config) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.connectTimeout()).setConnectionRequestTimeout(config.connectionRequestTimeout()).setSocketTimeout(config.socketTimeout()).build();
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setDefaultHeaders(NextGenDynamicMediaMetadataServiceImpl.convertHeaders(config.httpHeaders()));
        if (StringUtils.isNotBlank((CharSequence)config.proxyHost()) && config.proxyPort() > 0) {
            builder.setProxy(new HttpHost(config.proxyHost(), config.proxyPort()));
        }
        return builder.build();
    }

    private static Collection<Header> convertHeaders(String[] headers) {
        ArrayList<Header> result = new ArrayList<Header>();
        for (String header : headers) {
            String[] parts = header.split(":", 2);
            if (parts.length != 2) continue;
            result.add((Header)new BasicHeader(parts[0], parts[1]));
        }
        return result;
    }

    @Deactivate
    private void deactivate() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.imsAccessTokenCache = null;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public NextGenDynamicMediaMetadata fetchMetadata(@NotNull NextGenDynamicMediaReference reference) {
        NextGenDynamicMediaMetadata nextGenDynamicMediaMetadata;
        block11: {
            String accessToken;
            if (!this.enabled) {
                return null;
            }
            String metadataUrl = new NextGenDynamicMediaMetadataUrlBuilder(this.nextGenDynamicMediaConfig).build(reference);
            if (metadataUrl == null) {
                return null;
            }
            HttpGet httpGet = new HttpGet(metadataUrl);
            if (this.imsAccessTokenCache != null && (accessToken = this.imsAccessTokenCache.getAccessToken(this.authenticationClientId, this.authenticationClientSecret, this.authenticationScope)) != null) {
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            try {
                nextGenDynamicMediaMetadata = this.processResponse(response, metadataUrl);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    log.warn("Unable to fetch NGDM asset metadata from URL {}", (Object)metadataUrl, (Object)ex);
                    return null;
                }
            }
            response.close();
        }
        return nextGenDynamicMediaMetadata;
    }

    @Nullable
    private NextGenDynamicMediaMetadata processResponse(@NotNull CloseableHttpResponse response, @NotNull String metadataUrl) throws IOException {
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity());
                NextGenDynamicMediaMetadata metadata = NextGenDynamicMediaMetadata.fromJson(jsonResponse);
                log.trace("HTTP response for NGDM asset metadata {} returns: {}", (Object)metadataUrl, (Object)metadata);
                if (!metadata.isValid()) break;
                return metadata;
            }
            case 404: {
                log.trace("HTTP response for NGDM asset metadata {} returns HTTP 404", (Object)metadataUrl);
                break;
            }
            default: {
                log.warn("Unexpected HTTP response for NGDM asset metadata {}: {}", (Object)metadataUrl, (Object)response.getStatusLine());
            }
        }
        return null;
    }

    @ObjectClassDefinition(name="wcm.io Media Handler Dynamic Media with OpenAPI Metadata Service", description="Fetches metadata for Dynamic Media with OpenAPI remote assets.")
    static @interface Config {
        @AttributeDefinition(name="Enabled", description="When enabled, metadata is fetched for each resolved remote asset. This checks for validity/existence of the asset and for the maximum supported resolution of the original image, and allows to fetch Smart Cropping information.")
        public boolean enabled() default true;

        @AttributeDefinition(name="HTTP Headers", description="HTTP headers to be send with the asset metadata request. Format: 'header1:value1'.")
        public String[] httpHeaders();

        @AttributeDefinition(name="Connect Timeout", description="HTTP Connect timeout in milliseconds.")
        public int connectTimeout() default 5000;

        @AttributeDefinition(name="Connection Request Timeout", description="HTTP connection request timeout in milliseconds.")
        public int connectionRequestTimeout() default 5000;

        @AttributeDefinition(name="Socket Timeout", description="HTTP socket timeout in milliseconds.")
        public int socketTimeout() default 5000;

        @AttributeDefinition(name="Proxy Host", description="Proxy host name")
        public String proxyHost();

        @AttributeDefinition(name="Proxy Port", description="Proxy port")
        public int proxyPort();

        @AttributeDefinition(name="IMS Token API URL", description="API to obtain IMS access token for obtaining full metadata.")
        public String imsTokenApiUrl() default "https://ims-na1.adobelogin.com/ims/token/v3";

        @AttributeDefinition(name="IMS OAuth Client ID", description="Optional: If you want to fetch the full metadata for assets, provide the IMS OAuth Client ID.")
        public String authenticationClientId();

        @AttributeDefinition(name="IMS OAuth Client Secret", description="Optional: If you want to fetch the full metadata for assets, provide the IMS OAuth Client Secret.")
        public String authenticationClientSecret();

        @AttributeDefinition(name="IMS OAuth Scope", description="OAuth Scope to use for obtaining IMS access token.")
        public String authenticationScope() default "openid,AdobeID,read_organizations,additional_info.projectedProductContext,read_pc.dma_aem_ams";
    }
}

