/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl.metadata;

import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaConfigService;
import io.wcm.handler.mediasource.ngdm.impl.NextGenDynamicMediaReference;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NextGenDynamicMediaMetadataUrlBuilder {
    private final NextGenDynamicMediaConfigService config;

    NextGenDynamicMediaMetadataUrlBuilder(@NotNull NextGenDynamicMediaConfigService config) {
        this.config = config;
    }

    @Nullable
    public String build(@NotNull NextGenDynamicMediaReference reference) {
        String metadataPath;
        String repositoryId = reference.isLocal() ? this.config.getLocalAssetsRepositoryId() : this.config.getRemoteAssetsRepositoryId();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{repositoryId, metadataPath = this.config.getAssetMetadataPath()})) {
            return null;
        }
        metadataPath = StringUtils.replace((String)metadataPath, (String)"{asset-id}", (String)reference.getAssetId());
        StringBuilder url = new StringBuilder();
        if (StringUtils.startsWith((CharSequence)repositoryId, (CharSequence)"localhost:")) {
            url.append("http");
        } else {
            url.append("https");
        }
        url.append("://").append(repositoryId).append(metadataPath);
        return url.toString();
    }
}

