/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.ngdm.impl.metadata;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.mediasource.ngdm.impl.metadata.MetadataResponse;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SmartCrop {
    private final String name;
    private final CropDimension cropDimension;
    private final double ratio;

    SmartCrop(String name, double leftPercentage, double topPercentage, double widthPercentage, double heightPercentage, Dimension originalDimension) {
        long originalWidth = originalDimension.getWidth();
        long originalHeight = originalDimension.getHeight();
        long left = Math.round((double)originalWidth * leftPercentage);
        long top = Math.round((double)originalHeight * topPercentage);
        long width = Math.round((double)originalWidth * widthPercentage);
        long height = Math.round((double)originalHeight * heightPercentage);
        this.name = name;
        this.cropDimension = new CropDimension(left, top, width, height, true);
        this.ratio = Ratio.get(width, height);
    }

    SmartCrop(String name, MetadataResponse.SmartCrop smartCrop, Dimension originalDimension) {
        this(name, smartCrop.left, smartCrop.top, smartCrop.normalizedWidth, smartCrop.normalizedHeight, originalDimension);
    }

    public String getName() {
        return this.name;
    }

    public CropDimension getCropDimension() {
        return this.cropDimension;
    }

    public double getRatio() {
        return this.ratio;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE);
    }
}

