/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.impl;

import com.day.cq.wcm.api.Page;
import io.wcm.handler.richtext.RichTextHandler;
import io.wcm.handler.richtext.RichTextRewriteContentHandler;
import io.wcm.handler.richtext.util.RichTextUtil;
import io.wcm.sling.models.annotations.AemObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={RichTextHandler.class})
public final class RichTextHandlerImpl
implements RichTextHandler {
    static final Logger log = LoggerFactory.getLogger(RichTextHandlerImpl.class);
    @Self
    private RichTextRewriteContentHandler rewriteContentHandler;
    @AemObject
    private Page currentPage;

    @Override
    public void addContent(String text, Element parent, boolean supressParsingError) {
        try {
            this.addContent(text, parent);
        }
        catch (JDOMException ex) {
            if (supressParsingError) {
                log.debug("Unable to parse XHTML text." + (this.currentPage != null ? " Current page is " + this.currentPage.getPath() + "." : ""), (Throwable)ex);
            }
            throw new IllegalArgumentException("Unable to parse XHTML text.", ex);
        }
    }

    @Override
    public void addContent(String text, Element parent) throws JDOMException {
        if (this.isEmpty(text)) {
            return;
        }
        parent.addContent(this.getContent(text));
    }

    @Override
    public void addPlaintextContent(String text, Element parent) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        String[] lines = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)text, (String)"\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                parent.addContent((Content)new Element("br"));
            }
            parent.addContent(lines[i]);
        }
    }

    @Override
    public List<Content> getContent(String text) throws JDOMException {
        Element contentParent = RichTextUtil.parseText(text, true);
        this.rewriteContent(contentParent);
        return contentParent.cloneContent();
    }

    @Override
    public boolean isEmpty(String text) {
        return RichTextUtil.isEmpty(text);
    }

    private void rewriteContent(Element parent) {
        RichTextUtil.rewriteContent(parent, this.rewriteContentHandler);
    }
}

