/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.wcm.handler.link.LinkHandler;
import io.wcm.handler.link.LinkHandlerConfig;
import io.wcm.handler.link.LinkMetadata;
import io.wcm.handler.link.LinkType;
import io.wcm.handler.link.SyntheticLinkResource;
import io.wcm.handler.link.type.InternalLinkType;
import io.wcm.handler.link.type.MediaLinkType;
import io.wcm.handler.media.MediaHandler;
import io.wcm.handler.media.MediaMetadata;
import io.wcm.handler.richtext.RichTextRewriteContentHandler;
import io.wcm.handler.richtext.impl.DataPropertyUtil;
import io.wcm.handler.richtext.impl.RichTextHandlerImpl;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={RichTextRewriteContentHandler.class})
public final class RichTextRewriteContentHandlerImpl
implements RichTextRewriteContentHandler {
    @Self
    private Adaptable adaptable;
    @SlingObject
    private ResourceResolver resourceResolver;
    @Self
    private LinkHandler linkHandler;
    @Self
    private LinkHandlerConfig linkHandlerConfig;
    @Self
    private MediaHandler mediaHandler;
    private static final Set<String> NONSELFCLOSING_TAGS = ImmutableSet.of((Object)"div", (Object)"span", (Object)"strong", (Object)"em", (Object)"b", (Object)"i", (Object[])new String[]{"ul", "ol", "li"});
    private static final Map<String, String> LINKATTRIBUTE_MAPPING = ImmutableMap.builder().put((Object)"linktype", (Object)"linkType").put((Object)"linkanchorname", (Object)"linkAnchorName").put((Object)"linkqueryparams", (Object)"linkQueryParam").put((Object)"linkwindowwidth", (Object)"linkWindowWidth").put((Object)"linkwindowheight", (Object)"linkWindowHeight").put((Object)"linkmediadownload", (Object)"linkMediaDownload").put((Object)"linkwindowfeatures", (Object)"linkWindowFeatures").build();

    @Override
    public List<Content> rewriteElement(Element element) {
        if (StringUtils.equalsIgnoreCase((CharSequence)element.getName(), (CharSequence)"a")) {
            return this.rewriteAnchor(element);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)element.getName(), (CharSequence)"img")) {
            return this.rewriteImage(element);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)element.getName(), (CharSequence)"br")) {
            if (element.getContent().size() > 0) {
                element.removeContent();
            }
            return null;
        }
        if (NONSELFCLOSING_TAGS.contains(StringUtils.lowerCase((String)element.getName()))) {
            if (element.getContent().isEmpty()) {
                element.setText("");
            }
            return null;
        }
        return null;
    }

    protected List<Content> rewriteAnchor(Element element) {
        if (element.getContent().isEmpty()) {
            element.setText("");
        }
        LinkMetadata linkMetadata = this.getAnchorLinkMetadata(element);
        Element anchorElement = this.buildAnchorElement(linkMetadata, element);
        ArrayList<Content> content = new ArrayList<Content>();
        if (anchorElement != null) {
            anchorElement.addContent((Collection)element.cloneContent());
            content.add((Content)anchorElement);
        } else {
            content.addAll(element.getContent());
        }
        return content;
    }

    protected LinkMetadata getAnchorLinkMetadata(Element element) {
        SyntheticLinkResource resource = new SyntheticLinkResource(this.resourceResolver);
        ValueMap resourceProps = resource.getValueMap();
        boolean foundMetadata = this.getAnchorMetadataFromData(resourceProps, element);
        if (!foundMetadata && !(foundMetadata = this.getAnchorLegacyMetadataFromSingleData(resourceProps, element))) {
            this.getAnchorLegacyMetadataFromRel(resourceProps, element);
        }
        return this.linkHandler.getLinkMetadata((Resource)resource);
    }

    protected Element buildAnchorElement(LinkMetadata pLinkMetadata, Element element) {
        return pLinkMetadata.getAnchor();
    }

    protected boolean getAnchorMetadataFromData(ValueMap pResourceProps, Element element) {
        boolean foundAny = false;
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            String value;
            if (!DataPropertyUtil.isHtml5DataName(attribute.getName()) || !StringUtils.isNotEmpty((CharSequence)(value = attribute.getValue()))) continue;
            String property = DataPropertyUtil.toHeadlessCamelCaseName(attribute.getName());
            if (StringUtils.startsWith((CharSequence)value, (CharSequence)"[") && StringUtils.endsWith((CharSequence)value, (CharSequence)"]")) {
                try {
                    JSONArray jsonArray = new JSONArray(value);
                    String[] values = new String[jsonArray.length()];
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        values[i] = jsonArray.optString(i);
                    }
                    pResourceProps.put((Object)property, (Object)values);
                }
                catch (JSONException ex) {}
            } else {
                value = this.decodeIfEncoded(value);
                pResourceProps.put((Object)property, (Object)value);
            }
            foundAny = true;
        }
        return foundAny;
    }

    protected boolean getAnchorLegacyMetadataFromSingleData(ValueMap pResourceProps, Element element) {
        String metadataString;
        boolean foundAny = false;
        JSONObject metadata = null;
        Attribute dataAttribute = element.getAttribute("data");
        if (dataAttribute != null && StringUtils.isNotEmpty((CharSequence)(metadataString = dataAttribute.getValue()))) {
            try {
                metadata = new JSONObject(metadataString);
            }
            catch (JSONException ex) {
                RichTextHandlerImpl.log.debug("Invalid link metadata: " + metadataString, (Throwable)ex);
            }
        }
        if (metadata != null) {
            JSONArray names = metadata.names();
            for (int i = 0; i < names.length(); ++i) {
                String name = names.optString(i);
                pResourceProps.put((Object)name, metadata.opt(name));
                foundAny = true;
            }
        }
        return foundAny;
    }

    protected void getAnchorLegacyMetadataFromRel(ValueMap pResourceProps, Element element) {
        String htmlSuffix;
        JSONArray metadataPropertyNames;
        String href = element.getAttributeValue("href");
        String linkWindowTarget = element.getAttributeValue("target");
        if (href == null || href.startsWith("#")) {
            return;
        }
        JSONObject metadata = null;
        String metadataString = element.getAttributeValue("rel");
        if (StringUtils.isNotEmpty((CharSequence)metadataString)) {
            try {
                metadata = new JSONObject(metadataString);
            }
            catch (JSONException ex) {
                RichTextHandlerImpl.log.debug("Invalid link metadata: " + metadataString, (Throwable)ex);
            }
        }
        if (metadata == null) {
            metadata = new JSONObject();
        }
        if ((metadataPropertyNames = metadata.names()) != null) {
            for (int i = 0; i < metadataPropertyNames.length(); ++i) {
                String metadataPropertyName = metadataPropertyNames.optString(i);
                String jcrPropertyName = this.mapMetadataPropertyName(metadataPropertyName);
                JSONArray valueArray = metadata.optJSONArray(metadataPropertyName);
                if (valueArray != null) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (int j = 0; j < valueArray.length(); ++j) {
                        values.add(valueArray.optString(j));
                    }
                    pResourceProps.put((Object)jcrPropertyName, (Object)values.toArray(new String[values.size()]));
                    continue;
                }
                Object value = metadata.opt(metadataPropertyName);
                if (value == null) continue;
                pResourceProps.put((Object)jcrPropertyName, value);
            }
        }
        LinkType linkType = null;
        String linkTypeString = (String)pResourceProps.get("linkType", String.class);
        for (Class candidateClass : this.linkHandlerConfig.getLinkTypes()) {
            LinkType candidate = (LinkType)AdaptTo.notNull((Adaptable)this.adaptable, (Class)candidateClass);
            if (StringUtils.isNotEmpty((CharSequence)linkTypeString)) {
                if (!StringUtils.equals((CharSequence)linkTypeString, (CharSequence)candidate.getId())) continue;
                linkType = candidate;
                break;
            }
            if (!candidate.accepts(href)) continue;
            linkType = candidate;
            break;
        }
        if (linkType == null) {
            return;
        }
        if ((linkType instanceof InternalLinkType || linkType instanceof MediaLinkType) && StringUtils.endsWith((CharSequence)href, (CharSequence)(htmlSuffix = ".html"))) {
            href = StringUtils.substringBeforeLast((String)href, (String)htmlSuffix);
        }
        pResourceProps.put((Object)linkType.getPrimaryLinkRefProperty(), (Object)href);
        pResourceProps.put((Object)"linkWindowTarget", (Object)linkWindowTarget);
    }

    protected List<Content> rewriteImage(Element element) {
        MediaMetadata mediaMetadata = this.getImageMediaMetadata(element);
        Element imageElement = this.buildImageElement(mediaMetadata, element);
        ArrayList<Content> content = new ArrayList<Content>();
        if (imageElement != null) {
            content.add((Content)imageElement);
        }
        return content;
    }

    protected MediaMetadata getImageMediaMetadata(Element element) {
        String ref = element.getAttributeValue("src");
        if (StringUtils.isNotEmpty((CharSequence)ref)) {
            ref = this.unexternalizeImageRef(ref);
        }
        return this.mediaHandler.getMediaMetadata(ref);
    }

    protected Element buildImageElement(MediaMetadata pMediaMetadata, Element element) {
        if (pMediaMetadata.isValid()) {
            element.setAttribute("src", pMediaMetadata.getMediaUrl());
        }
        return element;
    }

    private String unexternalizeImageRef(String ref) {
        String unexternalizedRef = ref;
        if (StringUtils.isNotEmpty((CharSequence)unexternalizedRef)) {
            unexternalizedRef = this.decodeIfEncoded(unexternalizedRef);
            unexternalizedRef = StringUtils.removeEnd((String)unexternalizedRef, (String)"/jcr:content.default");
            unexternalizedRef = StringUtils.removeEnd((String)unexternalizedRef, (String)"/_jcr_content.default");
        }
        return unexternalizedRef;
    }

    private String decodeIfEncoded(String value) {
        if (StringUtils.contains((CharSequence)value, (CharSequence)"%")) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return value;
    }

    protected String mapMetadataPropertyName(String property) {
        String translation = LINKATTRIBUTE_MAPPING.get(property);
        if (StringUtils.isNotEmpty((CharSequence)translation)) {
            return translation;
        }
        return property;
    }
}

