/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.richtext.impl;

import com.day.cq.wcm.api.Page;
import com.google.common.collect.ImmutableList;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.richtext.RichText;
import io.wcm.handler.richtext.RichTextBuilder;
import io.wcm.handler.richtext.RichTextHandler;
import io.wcm.handler.richtext.RichTextRequest;
import io.wcm.handler.richtext.TextMode;
import io.wcm.handler.richtext.impl.RichTextBuilderImpl;
import io.wcm.handler.richtext.util.RewriteContentHandler;
import io.wcm.handler.richtext.util.RichTextUtil;
import io.wcm.handler.url.UrlMode;
import io.wcm.sling.models.annotations.AemObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={RichTextHandler.class})
public final class RichTextHandlerImpl
implements RichTextHandler {
    static final Logger log = LoggerFactory.getLogger(RichTextHandlerImpl.class);
    @Self
    private RewriteContentHandler rewriteContentHandler;
    @AemObject
    private Page currentPage;

    @Override
    public RichTextBuilder get(Resource resource) {
        return new RichTextBuilderImpl(resource, this);
    }

    @Override
    public RichTextBuilder get(String text) {
        return new RichTextBuilderImpl(text, this);
    }

    RichText processRequest(RichTextRequest richTextRequest) {
        String text = this.getRawText(richTextRequest);
        TextMode textMode = this.getTextMode(richTextRequest);
        List<Content> content = textMode == TextMode.XHTML ? this.processRichText(text, richTextRequest.getUrlMode(), richTextRequest.getMediaArgs()) : this.processPlainText(text);
        return new RichText(richTextRequest, content);
    }

    private String getRawText(RichTextRequest richTextRequest) {
        if (richTextRequest.getResource() != null) {
            return (String)richTextRequest.getResourceProperties().get("text", String.class);
        }
        return richTextRequest.getText();
    }

    private TextMode getTextMode(RichTextRequest richTextRequest) {
        if (richTextRequest.getTextMode() != null) {
            return richTextRequest.getTextMode();
        }
        if (richTextRequest.getResource() != null) {
            boolean textIsRich = (Boolean)richTextRequest.getResourceProperties().get("textIsRich", (Object)true);
            return textIsRich ? TextMode.XHTML : TextMode.PLAIN;
        }
        return TextMode.XHTML;
    }

    private List<Content> processRichText(String text, UrlMode urlMode, MediaArgs mediaArgs) {
        if (this.isEmpty(text)) {
            return ImmutableList.of();
        }
        try {
            Element contentParent = RichTextUtil.parseText(text, true);
            RichTextUtil.rewriteContent(contentParent, this.rewriteContentHandler);
            return ImmutableList.copyOf((Collection)contentParent.cloneContent());
        }
        catch (JDOMException ex) {
            log.debug("Unable to parse XHTML text." + (this.currentPage != null ? " Current page is " + this.currentPage.getPath() + "." : ""), (Throwable)ex);
            return ImmutableList.of();
        }
    }

    private List<Content> processPlainText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return ImmutableList.of();
        }
        ArrayList<Object> content = new ArrayList<Object>();
        String[] lines = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)text, (String)"\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                content.add(new Element("br"));
            }
            content.add(new Text(lines[i]));
        }
        return ImmutableList.copyOf(content);
    }

    @Override
    public boolean isEmpty(String text) {
        return RichTextUtil.isEmpty(text);
    }
}

